/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.worlds;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import org.bukkit.util.noise.SimplexOctaveGenerator;

public class PortalWorldGenerator
extends ChunkGenerator {
    public void generateNoise(WorldInfo worldInfo, Random random, int chunkX, int chunkZ, ChunkGenerator.ChunkData chunkData) {
        SimplexOctaveGenerator generator = new SimplexOctaveGenerator(new Random(worldInfo.getSeed()), 8);
        generator.setScale(0.02);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int y;
                int realX = chunkX * 16 + x;
                int realZ = chunkZ * 16 + z;
                double noise = generator.noise((double)realX, (double)realZ, 0.5, 0.5) * 20.0;
                int height = 50 + (int)noise;
                for (y = 0; y < height; ++y) {
                    if (y == 0) {
                        chunkData.setBlock(x, y, z, Material.BEDROCK);
                        continue;
                    }
                    if (y == height - 1) {
                        chunkData.setBlock(x, y, z, Material.NETHERRACK);
                        continue;
                    }
                    chunkData.setBlock(x, y, z, Material.BLACKSTONE);
                }
                if (height >= 45) continue;
                for (y = height; y < 45; ++y) {
                    chunkData.setBlock(x, y, z, Material.LAVA);
                }
            }
        }
    }

    public boolean shouldGenerateNoise() {
        return true;
    }

    public boolean shouldGenerateSurface() {
        return true;
    }

    public boolean shouldGenerateBedrock() {
        return true;
    }

    public boolean shouldGenerateCaves() {
        return true;
    }

    public boolean shouldGenerateMobs() {
        return true;
    }
}

