/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.worlds;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import org.bukkit.util.noise.SimplexOctaveGenerator;

public class LobbyGenerator
extends ChunkGenerator {
    public void generateNoise(WorldInfo worldInfo, Random random, int chunkX, int chunkZ, ChunkGenerator.ChunkData chunkData) {
        SimplexOctaveGenerator islandGen = new SimplexOctaveGenerator(new Random(worldInfo.getSeed()), 8);
        islandGen.setScale(0.01);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                double islandNoise;
                int realX = chunkX * 16 + x;
                int realZ = chunkZ * 16 + z;
                double distFromCenter = Math.sqrt(realX * realX + realZ * realZ);
                if (distFromCenter < 50.0) {
                    int baseHeight = 96;
                    double noise = islandGen.noise((double)realX, (double)realZ, 0.5, 0.5);
                    int variation = (int)(noise * 3.0);
                    int height = baseHeight + variation;
                    if (distFromCenter > 40.0) {
                        height -= (int)((distFromCenter - 40.0) * 0.5);
                    }
                    for (int y = 90; y <= height; ++y) {
                        if (y == height) {
                            chunkData.setBlock(x, y, z, Material.GRASS_BLOCK);
                            continue;
                        }
                        if (y > height - 3) {
                            chunkData.setBlock(x, y, z, Material.DIRT);
                            continue;
                        }
                        chunkData.setBlock(x, y, z, Material.STONE);
                    }
                    if (height < 250 && random.nextDouble() < 0.1) {
                        if (random.nextBoolean()) {
                            chunkData.setBlock(x, height + 1, z, Material.SHORT_GRASS);
                        } else if (random.nextDouble() < 0.3) {
                            Material[] flowers = new Material[]{Material.POPPY, Material.DANDELION, Material.BLUE_ORCHID};
                            chunkData.setBlock(x, height + 1, z, flowers[random.nextInt(flowers.length)]);
                        }
                    }
                }
                if (distFromCenter > 80.0 && distFromCenter < 200.0 && (islandNoise = islandGen.noise((double)realX * 0.5, (double)realZ * 0.5, 0.5, 0.5)) > 0.5) {
                    int islandHeight = 80 + (int)(islandNoise * 40.0);
                    int islandThickness = 4 + (int)(islandNoise * 8.0);
                    for (int y = islandHeight - islandThickness; y <= islandHeight; ++y) {
                        if (y == islandHeight) {
                            chunkData.setBlock(x, y, z, Material.GRASS_BLOCK);
                            continue;
                        }
                        if (y > islandHeight - 3) {
                            chunkData.setBlock(x, y, z, Material.DIRT);
                            continue;
                        }
                        chunkData.setBlock(x, y, z, Material.STONE);
                    }
                    if (islandNoise > 0.7 && random.nextDouble() < 0.15) {
                        chunkData.setBlock(x, islandHeight + 1, z, Material.OAK_SAPLING);
                    }
                }
                chunkData.setBlock(x, 0, z, Material.BEDROCK);
            }
        }
    }

    public boolean shouldGenerateNoise() {
        return false;
    }

    public boolean shouldGenerateSurface() {
        return false;
    }

    public boolean shouldGenerateBedrock() {
        return false;
    }

    public boolean shouldGenerateCaves() {
        return false;
    }

    public boolean shouldGenerateDecorations() {
        return false;
    }

    public boolean shouldGenerateMobs() {
        return false;
    }

    public boolean shouldGenerateStructures() {
        return false;
    }
}

