/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.worlds;

import com.dimensionrogue.models.DimensionData;
import com.dimensionrogue.worlds.BiomeType;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import org.bukkit.util.noise.SimplexOctaveGenerator;

public class DimensionGenerator
extends ChunkGenerator {
    private final DimensionData data;

    public DimensionGenerator(DimensionData data) {
        this.data = data;
    }

    public DimensionGenerator() {
        this.data = null;
    }

    public void generateNoise(WorldInfo worldInfo, Random random, int chunkX, int chunkZ, ChunkGenerator.ChunkData chunkData) {
        SimplexOctaveGenerator heightGen = new SimplexOctaveGenerator(new Random(worldInfo.getSeed()), 8);
        SimplexOctaveGenerator biomeGen = new SimplexOctaveGenerator(new Random(worldInfo.getSeed() + 1000L), 4);
        heightGen.setScale(0.01);
        biomeGen.setScale(0.003);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int realX = chunkX * 16 + x;
                int realZ = chunkZ * 16 + z;
                double biomeNoise = biomeGen.noise((double)realX, (double)realZ, 0.5, 0.5);
                BiomeType biome = this.getBiomeFromNoise(biomeNoise);
                double heightNoise = heightGen.noise((double)realX, (double)realZ, 0.5, 0.5);
                int baseHeight = biome.getMinHeight() + (int)((double)(biome.getMaxHeight() - biome.getMinHeight()) * ((heightNoise + 1.0) / 2.0));
                if (biome == BiomeType.CRYSTAL_PEAKS || biome == BiomeType.VOLCANIC_RIDGE || biome == BiomeType.FROZEN_SUMMIT || biome == BiomeType.STONE_PILLARS) {
                    double mountainNoise = heightGen.noise((double)(realX * 2), (double)(realZ * 2), 0.5, 0.5);
                    baseHeight += (int)(mountainNoise * 30.0);
                }
                for (int y = 0; y < Math.min(baseHeight, 255); ++y) {
                    Material ore;
                    if (y == 0) {
                        chunkData.setBlock(x, y, z, Material.BEDROCK);
                    } else if (y == baseHeight - 1) {
                        chunkData.setBlock(x, y, z, biome.getSurface());
                    } else if (y > baseHeight - 5) {
                        chunkData.setBlock(x, y, z, biome.getSubsurface());
                    } else {
                        chunkData.setBlock(x, y, z, Material.STONE);
                    }
                    if (y >= 64 || !(random.nextDouble() < 0.05) || (ore = this.getRandomOre(random, y)) == null) continue;
                    chunkData.setBlock(x, y, z, ore);
                }
                this.addBiomeFeatures(chunkData, x, baseHeight, z, biome, random);
            }
        }
    }

    private BiomeType getBiomeFromNoise(double noise) {
        BiomeType[] types = BiomeType.values();
        int index = (int)((noise + 1.0) / 2.0 * (double)types.length);
        index = Math.max(0, Math.min(index, types.length - 1));
        return types[index];
    }

    private Material getRandomOre(Random random, int y) {
        double chance = random.nextDouble();
        if (y < 16) {
            if (chance < 0.3) {
                return Material.DIAMOND_ORE;
            }
            if (chance < 0.6) {
                return Material.REDSTONE_ORE;
            }
        } else if (y < 32) {
            if (chance < 0.4) {
                return Material.GOLD_ORE;
            }
            if (chance < 0.7) {
                return Material.LAPIS_ORE;
            }
        } else {
            if (chance < 0.5) {
                return Material.IRON_ORE;
            }
            if (chance < 0.8) {
                return Material.COAL_ORE;
            }
        }
        return null;
    }

    private void addBiomeFeatures(ChunkGenerator.ChunkData chunkData, int x, int height, int z, BiomeType biome, Random random) {
        if (random.nextDouble() < 0.1) {
            switch (biome) {
                case MYSTIC_FOREST: 
                case DARK_WOODS: 
                case JUNGLE_TEMPLE: {
                    if (height >= 250) break;
                    chunkData.setBlock(x, height, z, Material.OAK_SAPLING);
                    break;
                }
                case FLOWER_FIELDS: {
                    if (height >= 250) break;
                    Material[] flowers = new Material[]{Material.POPPY, Material.DANDELION, Material.BLUE_ORCHID};
                    chunkData.setBlock(x, height, z, flowers[random.nextInt(flowers.length)]);
                    break;
                }
                case MUSHROOM_HAVEN: {
                    if (height >= 250) break;
                    Material mushroom = random.nextBoolean() ? Material.RED_MUSHROOM : Material.BROWN_MUSHROOM;
                    chunkData.setBlock(x, height, z, mushroom);
                    break;
                }
                case CRYSTAL_CAVES: {
                    if (height <= 30 || height >= 50 || !(random.nextDouble() < 0.15)) break;
                    chunkData.setBlock(x, height, z, Material.AMETHYST_CLUSTER);
                }
            }
        }
    }

    public boolean shouldGenerateNoise() {
        return true;
    }

    public boolean shouldGenerateSurface() {
        return true;
    }

    public boolean shouldGenerateBedrock() {
        return true;
    }

    public boolean shouldGenerateCaves() {
        return true;
    }

    public boolean shouldGenerateDecorations() {
        return true;
    }

    public boolean shouldGenerateMobs() {
        return true;
    }
}

