/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.worlds;

import org.bukkit.Material;

public enum BiomeType {
    FLOATING_ISLANDS(Material.GRASS_BLOCK, Material.STONE, 120, 140),
    CLOUD_PEAKS(Material.SNOW_BLOCK, Material.PACKED_ICE, 140, 160),
    VOID_RIFTS(Material.END_STONE, Material.OBSIDIAN, 100, 120),
    MYSTIC_FOREST(Material.GRASS_BLOCK, Material.MOSSY_COBBLESTONE, 70, 90),
    DARK_WOODS(Material.PODZOL, Material.DARK_OAK_LOG, 65, 85),
    JUNGLE_TEMPLE(Material.JUNGLE_LEAVES, Material.MOSSY_STONE_BRICKS, 75, 95),
    CHERRY_GROVE(Material.PINK_PETALS, Material.CHERRY_LOG, 70, 85),
    CRYSTAL_PEAKS(Material.AMETHYST_BLOCK, Material.CALCITE, 100, 180),
    VOLCANIC_RIDGE(Material.MAGMA_BLOCK, Material.BASALT, 80, 140),
    FROZEN_SUMMIT(Material.ICE, Material.PACKED_ICE, 90, 160),
    STONE_PILLARS(Material.STONE, Material.ANDESITE, 85, 130),
    GOLDEN_DUNES(Material.SAND, Material.SANDSTONE, 60, 75),
    GLASS_DESERT(Material.GLASS, Material.SAND, 62, 78),
    BADLANDS(Material.TERRACOTTA, Material.RED_SANDSTONE, 65, 90),
    OASIS(Material.GRASS_BLOCK, Material.SAND, 63, 72),
    DEEP_CAVERNS(Material.DEEPSLATE, Material.TUFF, 20, 50),
    CRYSTAL_CAVES(Material.AMETHYST_BLOCK, Material.DRIPSTONE_BLOCK, 25, 55),
    LUSH_CAVES(Material.MOSS_BLOCK, Material.CAVE_VINES, 30, 60),
    SCULK_DEPTHS(Material.SCULK, Material.DEEPSLATE, 15, 45),
    CORAL_REEF(Material.TUBE_CORAL_BLOCK, Material.PRISMARINE, 40, 65),
    DEEP_OCEAN(Material.WATER, Material.PRISMARINE_BRICKS, 30, 60),
    FROZEN_SEA(Material.ICE, Material.PACKED_ICE, 55, 70),
    KELP_FOREST(Material.KELP, Material.SAND, 45, 65),
    CRIMSON_WASTES(Material.CRIMSON_NYLIUM, Material.NETHERRACK, 65, 95),
    WARPED_SANCTUM(Material.WARPED_NYLIUM, Material.WARPED_WART_BLOCK, 70, 100),
    SOUL_VALLEY(Material.SOUL_SAND, Material.SOUL_SOIL, 60, 85),
    BASALT_DELTA(Material.BASALT, Material.BLACKSTONE, 68, 98),
    MUSHROOM_HAVEN(Material.MYCELIUM, Material.RED_MUSHROOM_BLOCK, 70, 85),
    FLOWER_FIELDS(Material.GRASS_BLOCK, Material.MOSS_BLOCK, 68, 78),
    AUTUMN_FOREST(Material.PODZOL, Material.OAK_LEAVES, 72, 88),
    SAKURA_VALLEY(Material.CHERRY_LEAVES, Material.PINK_PETALS, 70, 82);

    private final Material surface;
    private final Material subsurface;
    private final int minHeight;
    private final int maxHeight;

    private BiomeType(Material surface, Material subsurface, int minHeight, int maxHeight) {
        this.surface = surface;
        this.subsurface = subsurface;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
    }

    public Material getSurface() {
        return this.surface;
    }

    public Material getSubsurface() {
        return this.subsurface;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public static BiomeType random() {
        BiomeType[] values = BiomeType.values();
        return values[(int)(Math.random() * (double)values.length)];
    }
}

