/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.utils;

import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.util.Vector;

public class ParticleUtil {
    public static void drawWings(Location loc, Particle particle) {
        World world = loc.getWorld();
        Vector dir = loc.getDirection().setY(0).normalize();
        Vector right = dir.clone().crossProduct(new Vector(0, 1, 0)).normalize();
        for (double i = 0.0; i < 1.5; i += 0.1) {
            Location r = loc.clone().add(right.clone().multiply(0.5 + i)).add(0.0, 1.0 + i, 0.0).subtract(dir.clone().multiply(i * 0.5));
            world.spawnParticle(particle, r, 1, 0.0, 0.0, 0.0, 0.0);
            Location l = loc.clone().subtract(right.clone().multiply(0.5 + i)).add(0.0, 1.0 + i, 0.0).subtract(dir.clone().multiply(i * 0.5));
            world.spawnParticle(particle, l, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void drawHalo(Location loc, Particle particle) {
        World world = loc.getWorld();
        double radius = 0.4;
        for (double angle = 0.0; angle < Math.PI * 2; angle += 0.39269908169872414) {
            double x = Math.cos(angle) * radius;
            double z = Math.sin(angle) * radius;
            world.spawnParticle(particle, loc.clone().add(x, 2.2, z), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void drawHelix(Location loc, Particle particle) {
        World world = loc.getWorld();
        double radius = 1.0;
        double height = 2.0;
        long time = System.currentTimeMillis() / 100L;
        double angle = (double)(time % 20L) * 0.3141592653589793;
        double y = (double)(time % 20L) * (height / 20.0);
        double x = Math.cos(angle) * radius;
        double z = Math.sin(angle) * radius;
        world.spawnParticle(particle, loc.clone().add(x, y, z), 1, 0.0, 0.0, 0.0, 0.0);
        world.spawnParticle(particle, loc.clone().add(-x, y, -z), 1, 0.0, 0.0, 0.0, 0.0);
    }
}

