/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.models;

import java.util.UUID;
import org.bukkit.Location;

public class PortalData {
    private UUID id = UUID.randomUUID();
    private String type;
    private Location location;
    private long spawnTime;
    private long expiryTime;
    private String worldName;
    private boolean used;

    public PortalData(String type, Location location) {
        this.type = type;
        this.location = location;
        this.spawnTime = System.currentTimeMillis();
        this.expiryTime = this.spawnTime + 600000L;
        this.worldName = "portal_" + this.id.toString().substring(0, 8);
        this.used = false;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() >= this.expiryTime;
    }

    public long getRemainingTime() {
        return Math.max(0L, this.expiryTime - System.currentTimeMillis());
    }

    public UUID getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public Location getLocation() {
        return this.location;
    }

    public long getSpawnTime() {
        return this.spawnTime;
    }

    public long getExpiryTime() {
        return this.expiryTime;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public boolean isUsed() {
        return this.used;
    }

    public void setUsed(boolean used) {
        this.used = used;
    }
}

