/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.models;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class PlayerData {
    private UUID uuid;
    private String name;
    private int level;
    private long experience;
    private String rank;
    private long shards;
    private long fragments;
    private long echoes;
    private UUID dimensionId;
    private int dimensionLevel;
    private Map<String, Integer> abilityLevels;
    private List<String> equippedAbilities;
    private Set<String> unlockedCosmetics;
    private Map<String, String> equippedCosmetics;
    private Set<UUID> friends;
    private UUID currentParty;
    private Map<String, Long> statistics;
    private Set<String> completedQuests;
    private Set<String> unlockedAchievements;
    private Map<String, Integer> questProgress;
    private int battlePassLevel;
    private boolean premiumBattlePass;
    private Set<Integer> claimedBattlePassRewards;
    private Map<String, Object> settings;
    private long firstJoin;
    private long lastJoin;
    private long playtime;
    private boolean completedTutorial;
    private int tutorialStep;

    public PlayerData(UUID uuid) {
        this.uuid = uuid;
        this.name = "";
        this.level = 1;
        this.experience = 0L;
        this.rank = "Wanderer";
        this.shards = 1000L;
        this.fragments = 0L;
        this.echoes = 0L;
        this.dimensionId = uuid;
        this.dimensionLevel = 1;
        this.abilityLevels = new HashMap<String, Integer>();
        this.equippedAbilities = new ArrayList<String>();
        this.unlockedCosmetics = new HashSet<String>();
        this.equippedCosmetics = new HashMap<String, String>();
        this.friends = new HashSet<UUID>();
        this.currentParty = null;
        this.statistics = new HashMap<String, Long>();
        this.completedQuests = new HashSet<String>();
        this.unlockedAchievements = new HashSet<String>();
        this.questProgress = new HashMap<String, Integer>();
        this.battlePassLevel = 0;
        this.premiumBattlePass = false;
        this.claimedBattlePassRewards = new HashSet<Integer>();
        this.settings = new HashMap<String, Object>();
        this.firstJoin = System.currentTimeMillis();
        this.lastJoin = System.currentTimeMillis();
        this.playtime = 0L;
        this.completedTutorial = false;
        this.tutorialStep = 0;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public long getExperience() {
        return this.experience;
    }

    public void setExperience(long experience) {
        this.experience = experience;
    }

    public void addExperience(long amount) {
        this.experience += amount;
    }

    public String getRank() {
        return this.rank;
    }

    public void setRank(String rank) {
        this.rank = rank;
    }

    public long getShards() {
        return this.shards;
    }

    public void setShards(long shards) {
        this.shards = shards;
    }

    public long getFragments() {
        return this.fragments;
    }

    public void setFragments(long fragments) {
        this.fragments = fragments;
    }

    public long getEchoes() {
        return this.echoes;
    }

    public void setEchoes(long echoes) {
        this.echoes = echoes;
    }

    public void addCurrency(String type, long amount) {
        switch (type.toLowerCase()) {
            case "shards": {
                this.shards += amount;
                break;
            }
            case "fragments": {
                this.fragments += amount;
                break;
            }
            case "echoes": {
                this.echoes += amount;
            }
        }
    }

    public boolean removeCurrency(String type, long amount) {
        switch (type.toLowerCase()) {
            case "shards": {
                if (this.shards < amount) break;
                this.shards -= amount;
                return true;
            }
            case "fragments": {
                if (this.fragments < amount) break;
                this.fragments -= amount;
                return true;
            }
            case "echoes": {
                if (this.echoes < amount) break;
                this.echoes -= amount;
                return true;
            }
        }
        return false;
    }

    public UUID getDimensionId() {
        return this.dimensionId;
    }

    public void setDimensionId(UUID dimensionId) {
        this.dimensionId = dimensionId;
    }

    public int getDimensionLevel() {
        return this.dimensionLevel;
    }

    public void setDimensionLevel(int dimensionLevel) {
        this.dimensionLevel = dimensionLevel;
    }

    public Map<String, Integer> getAbilityLevels() {
        return this.abilityLevels;
    }

    public List<String> getEquippedAbilities() {
        return this.equippedAbilities;
    }

    public Set<String> getUnlockedCosmetics() {
        return this.unlockedCosmetics;
    }

    public Map<String, String> getEquippedCosmetics() {
        return this.equippedCosmetics;
    }

    public Set<UUID> getFriends() {
        return this.friends;
    }

    public UUID getCurrentParty() {
        return this.currentParty;
    }

    public void setCurrentParty(UUID partyId) {
        this.currentParty = partyId;
    }

    public Map<String, Long> getStatistics() {
        return this.statistics;
    }

    public void incrementStat(String stat, long amount) {
        this.statistics.put(stat, this.statistics.getOrDefault(stat, 0L) + amount);
    }

    public Set<String> getCompletedQuests() {
        return this.completedQuests;
    }

    public Set<String> getUnlockedAchievements() {
        return this.unlockedAchievements;
    }

    public Map<String, Integer> getQuestProgress() {
        return this.questProgress;
    }

    public int getBattlePassLevel() {
        return this.battlePassLevel;
    }

    public void setBattlePassLevel(int battlePassLevel) {
        this.battlePassLevel = battlePassLevel;
    }

    public boolean hasPremiumBattlePass() {
        return this.premiumBattlePass;
    }

    public void setPremiumBattlePass(boolean premium) {
        this.premiumBattlePass = premium;
    }

    public Set<Integer> getClaimedBattlePassRewards() {
        return this.claimedBattlePassRewards;
    }

    public Map<String, Object> getSettings() {
        return this.settings;
    }

    public long getFirstJoin() {
        return this.firstJoin;
    }

    public long getLastJoin() {
        return this.lastJoin;
    }

    public void setLastJoin(long lastJoin) {
        this.lastJoin = lastJoin;
    }

    public long getPlaytime() {
        return this.playtime;
    }

    public void addPlaytime(long time) {
        this.playtime += time;
    }

    public boolean hasCompletedTutorial() {
        return this.completedTutorial;
    }

    public void setCompletedTutorial(boolean completed) {
        this.completedTutorial = completed;
    }

    public int getTutorialStep() {
        return this.tutorialStep;
    }

    public void setTutorialStep(int step) {
        this.tutorialStep = step;
    }
}

