/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.models;

import com.dimensionrogue.models.PortalData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;

public class DimensionData {
    private UUID ownerId;
    private String worldName;
    private String biomeType;
    private double temperature;
    private double stability;
    private int darknessLevel;
    private double mobMutationRate;
    private double gravity;
    private double timeFlowSpeed;
    private String weatherType;
    private int level;
    private int size;
    private int difficulty;
    private List<String> activeLaws;
    private List<PortalData> activePortals;
    private int sizeUpgrades;
    private int difficultyUpgrades;
    private int lawSlots;
    private String currentEvent;
    private long eventEndTime;
    private Map<String, Long> statistics;
    private long created;
    private long lastAccessed;

    public DimensionData(UUID ownerId) {
        this.ownerId = ownerId;
        this.worldName = "dim_" + ownerId.toString().substring(0, 8);
        this.biomeType = this.getRandomBiomeType();
        this.temperature = 0.5;
        this.stability = 100.0;
        this.darknessLevel = 0;
        this.mobMutationRate = 0.1;
        this.gravity = 1.0;
        this.timeFlowSpeed = 1.0;
        this.weatherType = "CLEAR";
        this.level = 1;
        this.size = 500;
        this.difficulty = 1;
        this.activeLaws = new ArrayList<String>();
        this.activePortals = new ArrayList<PortalData>();
        this.sizeUpgrades = 0;
        this.difficultyUpgrades = 0;
        this.lawSlots = 1;
        this.currentEvent = null;
        this.eventEndTime = 0L;
        this.statistics = new HashMap<String, Long>();
        this.created = System.currentTimeMillis();
        this.lastAccessed = System.currentTimeMillis();
    }

    private String getRandomBiomeType() {
        String[] types = new String[]{"Arcane Forest", "Corrupted Plains", "Frozen Rift", "Volcanic Wastes", "Crystal Basin", "Void Sector", "Desert of Echoes", "Floating Skyland", "Deep Caves", "Time-Reversed Valley", "Neon Wasteland", "Ember Fields"};
        return types[new Random().nextInt(types.length)];
    }

    public UUID getOwnerId() {
        return this.ownerId;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public String getBiomeType() {
        return this.biomeType;
    }

    public void setBiomeType(String biomeType) {
        this.biomeType = biomeType;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    public double getStability() {
        return this.stability;
    }

    public void setStability(double stability) {
        this.stability = Math.max(0.0, Math.min(100.0, stability));
    }

    public void modifyStability(double amount) {
        this.setStability(this.stability + amount);
    }

    public int getDarknessLevel() {
        return this.darknessLevel;
    }

    public void setDarknessLevel(int darknessLevel) {
        this.darknessLevel = darknessLevel;
    }

    public double getMobMutationRate() {
        return this.mobMutationRate;
    }

    public void setMobMutationRate(double mobMutationRate) {
        this.mobMutationRate = mobMutationRate;
    }

    public double getGravity() {
        return this.gravity;
    }

    public void setGravity(double gravity) {
        this.gravity = gravity;
    }

    public double getTimeFlowSpeed() {
        return this.timeFlowSpeed;
    }

    public void setTimeFlowSpeed(double timeFlowSpeed) {
        this.timeFlowSpeed = timeFlowSpeed;
    }

    public String getWeatherType() {
        return this.weatherType;
    }

    public void setWeatherType(String weatherType) {
        this.weatherType = weatherType;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getDifficulty() {
        return this.difficulty;
    }

    public void setDifficulty(int difficulty) {
        this.difficulty = difficulty;
    }

    public List<String> getActiveLaws() {
        return this.activeLaws;
    }

    public List<PortalData> getActivePortals() {
        return this.activePortals;
    }

    public int getSizeUpgrades() {
        return this.sizeUpgrades;
    }

    public void incrementSizeUpgrades() {
        ++this.sizeUpgrades;
    }

    public int getDifficultyUpgrades() {
        return this.difficultyUpgrades;
    }

    public void incrementDifficultyUpgrades() {
        ++this.difficultyUpgrades;
    }

    public int getLawSlots() {
        return this.lawSlots;
    }

    public void setLawSlots(int lawSlots) {
        this.lawSlots = lawSlots;
    }

    public String getCurrentEvent() {
        return this.currentEvent;
    }

    public void setCurrentEvent(String event) {
        this.currentEvent = event;
    }

    public long getEventEndTime() {
        return this.eventEndTime;
    }

    public void setEventEndTime(long time) {
        this.eventEndTime = time;
    }

    public Map<String, Long> getStatistics() {
        return this.statistics;
    }

    public long getCreated() {
        return this.created;
    }

    public long getLastAccessed() {
        return this.lastAccessed;
    }

    public void updateLastAccessed() {
        this.lastAccessed = System.currentTimeMillis();
    }
}

