/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.managers;

import com.dimensionrogue.DimensionRogue;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class TutorialManager
implements Listener {
    private final DimensionRogue plugin;

    public TutorialManager(DimensionRogue plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPlayedBefore()) {
            this.startTutorial(player);
        }
    }

    public void startTutorial(Player player) {
        player.sendMessage("\u00a7a\u00a7lWELCOME TO DIMENSION ROGUE!");
        player.playSound(player.getLocation(), Sound.UI_TOAST_CHALLENGE_COMPLETE, 1.0f, 1.0f);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            player.sendTitle("\u00a75DIMENSION ROGUE", "\u00a7dYour journey begins...", 10, 70, 20);
            player.sendMessage("\u00a77[Guide] Welcome, traveler. You have entered the Rift.");
        }, 40L);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            player.sendMessage("\u00a77[Guide] Every player here has their own \u00a7dPersonal Dimension\u00a77.");
            player.sendMessage("\u00a77[Guide] Type \u00a7e/dimension\u00a77 to visit yours.");
        }, 140L);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> player.sendMessage("\u00a77[Guide] Watch out for \u00a75Void Rifts\u00a77. They lead to dangerous worlds with high rewards."), 240L);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            player.sendMessage("\u00a77[Guide] Collect \u00a7bShards\u00a77 to buy items in \u00a7e/shop\u00a77.");
            player.sendMessage("\u00a7aGood luck!");
            this.plugin.getCurrencyManager().addCurrency(player, "shards", 100L);
            player.sendMessage("\u00a7a+100 Shards (Starter Bonus)");
        }, 340L);
    }
}

