/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.managers;

import com.dimensionrogue.DimensionRogue;
import com.dimensionrogue.models.PlayerData;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TabListManager {
    private final DimensionRogue plugin;

    public TabListManager(DimensionRogue plugin) {
        this.plugin = plugin;
        this.startTabListUpdater();
    }

    private void startTabListUpdater() {
        Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                this.updateTabList(player);
            }
        }, 20L, 100L);
    }

    public void updateTabList(Player player) {
        Component header = ((TextComponent)((TextComponent)Component.text((String)"\u00a78\u00a7m                    \u00a7r\n").append((Component)Component.text((String)"\u00a75\u00a7lDIMENSION ROGUE\n"))).append((Component)Component.text((String)("\u00a77" + Bukkit.getOnlinePlayers().size() + " Players Online\n")))).append((Component)Component.text((String)"\u00a78\u00a7m                    \u00a7r"));
        PlayerData data = this.plugin.getPlayerDataManager().getPlayerData(player);
        String rankColor = this.getRankColor(data != null ? data.getRank() : "Wanderer");
        Component footer = ((TextComponent)((TextComponent)((TextComponent)Component.text((String)"\n\u00a78\u00a7m                    \u00a7r\n").append((Component)Component.text((String)("\u00a77Rank: " + rankColor + (data != null ? data.getRank() : "Wanderer") + "\n")))).append((Component)Component.text((String)("\u00a77Level: \u00a7b" + (data != null ? data.getLevel() : 1) + "\n")))).append((Component)Component.text((String)"\u00a77dimensionrogue.net\n"))).append((Component)Component.text((String)"\u00a78\u00a7m                    \u00a7r"));
        player.sendPlayerListHeaderAndFooter(header, footer);
        if (data != null) {
            String prefix = rankColor + "[" + data.getRank() + "] \u00a7f";
            player.playerListName((Component)Component.text((String)(prefix + player.getName())));
        }
    }

    private String getRankColor(String rank) {
        return switch (rank) {
            case "God" -> "\u00a75";
            case "Legend" -> "\u00a76";
            case "Master" -> "\u00a7c";
            case "Warrior" -> "\u00a7e";
            case "Knight" -> "\u00a79";
            case "Scout" -> "\u00a7a";
            case "Nomad" -> "\u00a72";
            default -> "\u00a77";
        };
    }
}

