/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.managers;

import com.dimensionrogue.DimensionRogue;
import com.dimensionrogue.models.PlayerData;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;

public class ScoreboardManager {
    private final DimensionRogue plugin;

    public ScoreboardManager(DimensionRogue plugin) {
        this.plugin = plugin;
    }

    public void updateAllScoreboards() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.updateScoreboard(player);
        }
    }

    public void updateScoreboard(Player player) {
        PlayerData data;
        Objective obj;
        Scoreboard board = player.getScoreboard();
        if (board.equals((Object)Bukkit.getScoreboardManager().getMainScoreboard())) {
            board = Bukkit.getScoreboardManager().getNewScoreboard();
            player.setScoreboard(board);
        }
        if ((obj = board.getObjective("rogue")) == null) {
            obj = board.registerNewObjective("rogue", Criteria.DUMMY, (Component)Component.text((String)"\u00a75\u00a7lDIMENSION ROGUE"));
            obj.setDisplaySlot(DisplaySlot.SIDEBAR);
        }
        if ((data = this.plugin.getPlayerDataManager().getPlayerData(player)) == null) {
            return;
        }
        this.setScore(obj, "\u00a77----------------", 10);
        this.setScore(obj, "\u00a7fRank: \u00a7d" + data.getRank(), 9);
        this.setScore(obj, "\u00a7fLevel: \u00a7b" + data.getLevel(), 8);
        this.setScore(obj, "\u00a7fXP: \u00a77" + data.getExperience() + "/" + data.getLevel() * 1000, 7);
        this.setScore(obj, " ", 6);
        this.setScore(obj, "\u00a7fShards: \u00a7a" + data.getShards(), 5);
        this.setScore(obj, "\u00a7fFragments: \u00a75" + data.getFragments(), 4);
        this.setScore(obj, "\u00a7fEchoes: \u00a7c" + data.getEchoes(), 3);
        this.setScore(obj, "  ", 2);
        this.setScore(obj, "\u00a77dimensionrogue.net", 1);
    }

    private void setScore(Objective obj, String text, int score) {
        Score s = obj.getScore(text);
        s.setScore(score);
    }
}

