/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.managers;

import com.dimensionrogue.DimensionRogue;
import com.dimensionrogue.models.PlayerData;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class RankManager {
    private final DimensionRogue plugin;
    private final List<String> ranks = Arrays.asList("Wanderer", "Scout", "Raider", "Slayer", "Champion", "Lord", "Titan", "God");

    public RankManager(DimensionRogue plugin) {
        this.plugin = plugin;
    }

    public void rankUp(Player player) {
        PlayerData data = this.plugin.getPlayerDataManager().getPlayerData(player);
        String currentRank = data.getRank();
        int currentIndex = this.ranks.indexOf(currentRank);
        if (currentIndex == -1 || currentIndex >= this.ranks.size() - 1) {
            player.sendMessage("\u00a7cYou are already at the highest rank!");
            return;
        }
        String nextRank = this.ranks.get(currentIndex + 1);
        long cost = (long)(currentIndex + 1) * 5000L;
        if (!this.plugin.getCurrencyManager().hasEnough(player, "shards", cost)) {
            player.sendMessage("\u00a7cYou need \u00a7e" + cost + " Shards \u00a7cto rank up to " + nextRank);
            return;
        }
        this.plugin.getCurrencyManager().removeCurrency(player, "shards", cost);
        data.setRank(nextRank);
        player.sendMessage("\u00a7a\u00a7lRANK UP! \u00a77You are now a \u00a7e" + nextRank);
        player.playSound(player.getLocation(), Sound.UI_TOAST_CHALLENGE_COMPLETE, 1.0f, 1.0f);
    }

    public String getNextRank(String currentRank) {
        int index = this.ranks.indexOf(currentRank);
        if (index >= 0 && index < this.ranks.size() - 1) {
            return this.ranks.get(index + 1);
        }
        return "None";
    }
}

