/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.managers;

import com.dimensionrogue.DimensionRogue;
import com.dimensionrogue.models.PlayerData;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class QuestManager {
    private final DimensionRogue plugin;
    private final Map<String, String> dailyQuests;

    public QuestManager(DimensionRogue plugin) {
        this.plugin = plugin;
        this.dailyQuests = new HashMap<String, String>();
        this.generateDailyQuests();
    }

    private void generateDailyQuests() {
        this.dailyQuests.put("kill_zombies", "Kill 50 Zombies");
        this.dailyQuests.put("mine_stone", "Mine 200 Stone");
        this.dailyQuests.put("play_time", "Play for 1 Hour");
    }

    public void checkProgress(Player player, String questId, int amount) {
        int target;
        PlayerData data = this.plugin.getPlayerDataManager().getPlayerData(player);
        if (data.getCompletedQuests().contains(questId)) {
            return;
        }
        int current = data.getQuestProgress().getOrDefault(questId, 0);
        if (current + amount >= (target = this.getTarget(questId))) {
            this.completeQuest(player, questId);
        } else {
            data.getQuestProgress().put(questId, current + amount);
        }
    }

    private int getTarget(String questId) {
        switch (questId) {
            case "kill_zombies": {
                return 50;
            }
            case "mine_stone": {
                return 200;
            }
            case "play_time": {
                return 60;
            }
        }
        return 100;
    }

    private void completeQuest(Player player, String questId) {
        PlayerData data = this.plugin.getPlayerDataManager().getPlayerData(player);
        data.getCompletedQuests().add(questId);
        this.plugin.getCurrencyManager().addCurrency(player, "shards", 500L);
        this.plugin.getBattlePassManager().addXP(player, 100);
        player.sendMessage("\u00a7a\u00a7lQUEST COMPLETE! \u00a77" + this.dailyQuests.get(questId));
        player.sendMessage("\u00a7e+500 Shards, +100 BP XP");
        player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
    }

    public Map<String, String> getDailyQuests() {
        return this.dailyQuests;
    }
}

