/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.managers;

import com.dimensionrogue.DimensionRogue;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class PvPManager {
    private final DimensionRogue plugin;
    private final Map<UUID, String> inArena;
    private final Map<String, Location> arenas;

    public PvPManager(DimensionRogue plugin) {
        this.plugin = plugin;
        this.inArena = new HashMap<UUID, String>();
        this.arenas = new HashMap<String, Location>();
        this.arenas.put("default", new Location(Bukkit.getWorld((String)"world"), 100.0, 100.0, 100.0));
    }

    public void joinArena(Player player, String arenaId) {
        if (this.inArena.containsKey(player.getUniqueId())) {
            player.sendMessage("\u00a7cYou are already in an arena!");
            return;
        }
        Location spawn = this.arenas.get(arenaId);
        if (spawn == null) {
            player.sendMessage("\u00a7cArena not found.");
            return;
        }
        this.inArena.put(player.getUniqueId(), arenaId);
        player.teleport(spawn);
        this.giveKit(player);
        player.sendMessage("\u00a7aJoined arena: " + arenaId);
    }

    public void leaveArena(Player player) {
        if (!this.inArena.containsKey(player.getUniqueId())) {
            player.sendMessage("\u00a7cYou are not in an arena.");
            return;
        }
        this.inArena.remove(player.getUniqueId());
        player.teleport(Bukkit.getWorld((String)"world").getSpawnLocation());
        player.getInventory().clear();
        player.sendMessage("\u00a7cLeft arena.");
    }

    private void giveKit(Player player) {
        player.getInventory().clear();
        player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.IRON_SWORD)});
        player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.BOW)});
        player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.ARROW, 64)});
        player.getInventory().setHelmet(new ItemStack(Material.IRON_HELMET));
        player.getInventory().setChestplate(new ItemStack(Material.IRON_CHESTPLATE));
        player.getInventory().setLeggings(new ItemStack(Material.IRON_LEGGINGS));
        player.getInventory().setBoots(new ItemStack(Material.IRON_BOOTS));
    }

    public boolean isInArena(Player player) {
        return this.inArena.containsKey(player.getUniqueId());
    }
}

