/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.managers;

import com.dimensionrogue.DimensionRogue;
import com.dimensionrogue.models.PortalData;
import com.dimensionrogue.worlds.PortalWorldGenerator;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.Plugin;

public class PortalManager
implements Listener {
    private final DimensionRogue plugin;
    private final Map<UUID, PortalData> activePortals;
    private final Map<Location, UUID> portalLocations;
    private final Random random = new Random();

    public PortalManager(DimensionRogue plugin) {
        this.plugin = plugin;
        this.activePortals = new ConcurrentHashMap<UUID, PortalData>();
        this.portalLocations = new ConcurrentHashMap<Location, UUID>();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void checkPortalSpawns() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!this.plugin.getDimensionManager().isDimensionWorld(player.getWorld()) || !(this.random.nextDouble() < 0.05)) continue;
            this.spawnPortalNear(player);
        }
        long now = System.currentTimeMillis();
        this.activePortals.values().removeIf(portal -> {
            if (portal.getExpiryTime() < now) {
                this.removePortal((PortalData)portal);
                return true;
            }
            return false;
        });
    }

    private void spawnPortalNear(Player player) {
        Location loc = player.getLocation().add((double)(this.random.nextInt(20) - 10), 0.0, (double)(this.random.nextInt(20) - 10));
        loc.setY((double)(player.getWorld().getHighestBlockYAt(loc) + 1));
        String type = "VOID_RIFT";
        PortalData portal = new PortalData(type, loc);
        UUID id = portal.getId();
        this.activePortals.put(id, portal);
        this.portalLocations.put(loc.getBlock().getLocation(), id);
        loc.getBlock().setType(Material.END_GATEWAY);
        player.sendMessage("\u00a75\u00a7kA \u00a7d\u00a7lA MYSTERIOUS PORTAL HAS OPENED NEARBY! \u00a75\u00a7kA");
        player.playSound(loc, Sound.BLOCK_END_PORTAL_SPAWN, 1.0f, 1.0f);
    }

    private void removePortal(PortalData portal) {
        Location loc = portal.getLocation();
        if (loc.getWorld() != null) {
            loc.getBlock().setType(Material.AIR);
            loc.getWorld().playSound(loc, Sound.BLOCK_GLASS_BREAK, 1.0f, 0.5f);
        }
        this.portalLocations.remove(loc.getBlock().getLocation());
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getClickedBlock() == null) {
            return;
        }
        UUID portalId = this.portalLocations.get(event.getClickedBlock().getLocation());
        if (portalId != null) {
            event.setCancelled(true);
            this.enterPortal(event.getPlayer(), this.activePortals.get(portalId));
        }
    }

    private void enterPortal(Player player, PortalData portal) {
        player.sendMessage("\u00a75Entering the Void Rift...");
        player.playSound(player.getLocation(), Sound.BLOCK_PORTAL_TRAVEL, 1.0f, 1.0f);
        String worldName = "portal_" + portal.getId().toString();
        WorldCreator creator = new WorldCreator(worldName);
        creator.generator((ChunkGenerator)new PortalWorldGenerator());
        World world = creator.createWorld();
        player.teleport(new Location(world, 0.0, 60.0, 0.0));
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (player.isOnline() && player.getWorld().getName().equals(worldName)) {
                player.teleport(((World)Bukkit.getWorlds().get(0)).getSpawnLocation());
                player.sendMessage("\u00a7cThe portal world is collapsing!");
            }
            Bukkit.unloadWorld((World)world, (boolean)false);
        }, 6000L);
    }
}

