/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.managers;

import com.dimensionrogue.DimensionRogue;
import com.dimensionrogue.models.PlayerData;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;

public class PlayerDataManager {
    private final DimensionRogue plugin;
    private final Map<UUID, PlayerData> loadedPlayerData;

    public PlayerDataManager(DimensionRogue plugin) {
        this.plugin = plugin;
        this.loadedPlayerData = new ConcurrentHashMap<UUID, PlayerData>();
    }

    public void loadPlayer(Player player) {
        this.plugin.getDatabaseManager().loadPlayerData(player.getUniqueId()).thenAccept(data -> {
            data.setName(player.getName());
            data.setLastJoin(System.currentTimeMillis());
            this.loadedPlayerData.put(player.getUniqueId(), (PlayerData)data);
        });
    }

    public void unloadPlayer(Player player) {
        PlayerData data = this.loadedPlayerData.remove(player.getUniqueId());
        if (data != null) {
            this.plugin.getDatabaseManager().savePlayerData(data);
        }
    }

    public PlayerData getPlayerData(UUID uuid) {
        return this.loadedPlayerData.get(uuid);
    }

    public PlayerData getPlayerData(Player player) {
        return this.getPlayerData(player.getUniqueId());
    }

    public void saveAllPlayers() {
        for (PlayerData data : this.loadedPlayerData.values()) {
            this.plugin.getDatabaseManager().savePlayerData(data);
        }
    }

    public Collection<PlayerData> getAllPlayerData() {
        return this.loadedPlayerData.values();
    }
}

