/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.managers;

import com.dimensionrogue.DimensionRogue;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class PartyManager {
    private final DimensionRogue plugin;
    private final Map<UUID, Set<UUID>> parties;
    private final Map<UUID, UUID> playerParty;
    private final Map<UUID, UUID> invites;

    public PartyManager(DimensionRogue plugin) {
        this.plugin = plugin;
        this.parties = new ConcurrentHashMap<UUID, Set<UUID>>();
        this.playerParty = new ConcurrentHashMap<UUID, UUID>();
        this.invites = new ConcurrentHashMap<UUID, UUID>();
    }

    public void createParty(Player leader) {
        if (this.playerParty.containsKey(leader.getUniqueId())) {
            leader.sendMessage("\u00a7cYou are already in a party!");
            return;
        }
        HashSet<UUID> members = new HashSet<UUID>();
        members.add(leader.getUniqueId());
        this.parties.put(leader.getUniqueId(), members);
        this.playerParty.put(leader.getUniqueId(), leader.getUniqueId());
        leader.sendMessage("\u00a7aParty created!");
    }

    public void invitePlayer(Player leader, Player target) {
        if (!this.isLeader(leader)) {
            leader.sendMessage("\u00a7cYou are not the party leader!");
            return;
        }
        if (this.playerParty.containsKey(target.getUniqueId())) {
            leader.sendMessage("\u00a7c" + target.getName() + " is already in a party.");
            return;
        }
        this.invites.put(target.getUniqueId(), leader.getUniqueId());
        leader.sendMessage("\u00a7aInvited " + target.getName() + " to the party.");
        target.sendMessage("\u00a7e" + leader.getName() + " \u00a77invited you to their party.");
        target.sendMessage("\u00a77Type \u00a7a/party accept \u00a77to join.");
    }

    public void acceptInvite(Player player) {
        UUID inviterId = this.invites.remove(player.getUniqueId());
        if (inviterId == null || !this.parties.containsKey(inviterId)) {
            player.sendMessage("\u00a7cNo active invites.");
            return;
        }
        this.parties.get(inviterId).add(player.getUniqueId());
        this.playerParty.put(player.getUniqueId(), inviterId);
        this.broadcastToParty(inviterId, "\u00a7a" + player.getName() + " joined the party!");
    }

    public void leaveParty(Player player) {
        UUID leaderId = this.playerParty.remove(player.getUniqueId());
        if (leaderId == null) {
            player.sendMessage("\u00a7cYou are not in a party.");
            return;
        }
        Set<UUID> members = this.parties.get(leaderId);
        members.remove(player.getUniqueId());
        this.broadcastToParty(leaderId, "\u00a7c" + player.getName() + " left the party.");
        player.sendMessage("\u00a7cYou left the party.");
        if (player.getUniqueId().equals(leaderId)) {
            this.disbandParty(leaderId);
        } else if (members.isEmpty()) {
            this.parties.remove(leaderId);
        }
    }

    public void disbandParty(UUID leaderId) {
        Set<UUID> members = this.parties.remove(leaderId);
        if (members != null) {
            for (UUID memberId : members) {
                this.playerParty.remove(memberId);
                Player member = Bukkit.getPlayer((UUID)memberId);
                if (member == null) continue;
                member.sendMessage("\u00a7cThe party was disbanded.");
            }
        }
    }

    public void chat(Player player, String message) {
        UUID leaderId = this.playerParty.get(player.getUniqueId());
        if (leaderId == null) {
            player.sendMessage("\u00a7cYou are not in a party.");
            return;
        }
        this.broadcastToParty(leaderId, "\u00a7d[Party] " + player.getName() + ": \u00a7f" + message);
    }

    private void broadcastToParty(UUID leaderId, String message) {
        Set<UUID> members = this.parties.get(leaderId);
        if (members != null) {
            for (UUID memberId : members) {
                Player member = Bukkit.getPlayer((UUID)memberId);
                if (member == null) continue;
                member.sendMessage(message);
            }
        }
    }

    public boolean isLeader(Player player) {
        return this.parties.containsKey(player.getUniqueId());
    }

    public boolean isInParty(Player player) {
        return this.playerParty.containsKey(player.getUniqueId());
    }
}

