/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.managers;

import com.dimensionrogue.DimensionRogue;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class ParkourManager {
    private final DimensionRogue plugin;
    private final Map<UUID, Location> checkpoints;

    public ParkourManager(DimensionRogue plugin) {
        this.plugin = plugin;
        this.checkpoints = new HashMap<UUID, Location>();
    }

    public void startParkour(Player player) {
        Location start = new Location(Bukkit.getWorld((String)"world"), 0.0, 150.0, 0.0);
        player.teleport(start);
        this.checkpoints.put(player.getUniqueId(), start);
        player.sendMessage("\u00a7aParkour started! Fall to reset.");
    }

    public void checkpoint(Player player) {
        this.checkpoints.put(player.getUniqueId(), player.getLocation());
        player.sendMessage("\u00a7eCheckpoint reached!");
        player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 2.0f);
    }

    public void reset(Player player) {
        Location cp = this.checkpoints.get(player.getUniqueId());
        if (cp != null) {
            player.teleport(cp);
        }
    }
}

