/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.managers;

import com.dimensionrogue.DimensionRogue;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class NPCManager
implements Listener {
    private final DimensionRogue plugin;
    private final List<Entity> npcs = new ArrayList<Entity>();

    public NPCManager(DimensionRogue plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void spawnLobbyNPCs() {
        Location lobbySpawn = this.plugin.getLobbyManager().getLobbySpawn();
        this.removeAllNPCs();
        this.spawnNPCFromConfig("guide", lobbySpawn.clone().add(5.0, 0.0, 0.0), EntityType.VILLAGER, "\u00a7b\u00a7lRift Guide", Material.ENCHANTED_BOOK);
        this.spawnNPCFromConfig("shop", lobbySpawn.clone().add(-5.0, 0.0, 0.0), EntityType.VILLAGER, "\u00a7a\u00a7lShop Keeper", Material.EMERALD);
        this.spawnNPCFromConfig("quest", lobbySpawn.clone().add(0.0, 0.0, 5.0), EntityType.VILLAGER, "\u00a7e\u00a7lQuest Master", Material.WRITABLE_BOOK);
        this.spawnNPCFromConfig("blacksmith", lobbySpawn.clone().add(0.0, 0.0, -5.0), EntityType.VILLAGER, "\u00a7c\u00a7lBlacksmith", Material.IRON_SWORD);
        this.spawnNPCFromConfig("portal", lobbySpawn.clone().add(7.0, 0.0, 7.0), EntityType.ARMOR_STAND, "\u00a75\u00a7lPortal Master", Material.END_PORTAL_FRAME);
    }

    private void spawnNPCFromConfig(String npcId, Location defaultLoc, EntityType type, String name, Material item) {
        String path = "lobby.npcs." + npcId;
        if (this.plugin.getConfig().contains(path)) {
            double x = this.plugin.getConfig().getDouble(path + ".x");
            double y = this.plugin.getConfig().getDouble(path + ".y");
            double z = this.plugin.getConfig().getDouble(path + ".z");
            float yaw = (float)this.plugin.getConfig().getDouble(path + ".yaw", 0.0);
            defaultLoc = new Location(defaultLoc.getWorld(), x, y, z, yaw, 0.0f);
        }
        this.spawnNPC(defaultLoc, type, name, item);
    }

    private void spawnNPC(Location loc, EntityType type, String name, Material item) {
        if (type == EntityType.VILLAGER) {
            Villager npc = (Villager)loc.getWorld().spawnEntity(loc, EntityType.VILLAGER);
            npc.setCustomName(name);
            npc.setCustomNameVisible(true);
            npc.setAI(false);
            npc.setInvulnerable(true);
            npc.setSilent(true);
            npc.setProfession(Villager.Profession.NONE);
            this.npcs.add((Entity)npc);
        } else if (type == EntityType.ARMOR_STAND) {
            ArmorStand npc = (ArmorStand)loc.getWorld().spawnEntity(loc, EntityType.ARMOR_STAND);
            npc.setCustomName(name);
            npc.setCustomNameVisible(true);
            npc.setGravity(false);
            npc.setInvulnerable(true);
            npc.setBasePlate(false);
            npc.setArms(true);
            npc.getEquipment().setHelmet(new ItemStack(item));
            this.npcs.add((Entity)npc);
        }
    }

    @EventHandler
    public void onNPCClick(PlayerInteractEntityEvent event) {
        Entity entity = event.getRightClicked();
        Player player = event.getPlayer();
        if (!this.npcs.contains(entity)) {
            return;
        }
        event.setCancelled(true);
        String name = entity.getCustomName();
        if (name == null) {
            return;
        }
        if (name.contains("Guide")) {
            player.sendMessage("\u00a7b[Guide] \u00a77Welcome to DEMO!");
            player.sendMessage("\u00a77Use \u00a7e/dimension\u00a77 to visit your personal world.");
            player.sendMessage("\u00a77Watch for \u00a75Void Rifts\u00a77 - they lead to adventure!");
        } else if (name.contains("Shop")) {
            player.performCommand("shop");
        } else if (name.contains("Quest")) {
            player.performCommand("quest");
        } else if (name.contains("Blacksmith")) {
            player.sendMessage("\u00a7c[Blacksmith] \u00a77I can upgrade your gear... for a price.");
            player.sendMessage("\u00a77(Feature coming soon!)");
        } else if (name.contains("Portal")) {
            player.sendMessage("\u00a75[Portal Master] \u00a77The Void Rifts appear randomly in dimensions.");
            player.sendMessage("\u00a77Enter them to find rare loot and powerful bosses!");
        }
    }

    public void removeNearestNPC(Location location, double radius) {
        Entity nearest = null;
        double nearestDist = radius;
        for (Entity npc : this.npcs) {
            double dist = npc.getLocation().distance(location);
            if (!(dist < nearestDist)) continue;
            nearest = npc;
            nearestDist = dist;
        }
        if (nearest != null) {
            this.npcs.remove(nearest);
            nearest.remove();
        }
    }

    public void removeAllNPCs() {
        this.npcs.forEach(Entity::remove);
        this.npcs.clear();
    }
}

