/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.managers;

import com.dimensionrogue.DimensionRogue;
import com.dimensionrogue.mobs.MobTier;
import java.util.Random;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class MobManager {
    private final DimensionRogue plugin;
    private final Random random;

    public MobManager(DimensionRogue plugin) {
        this.plugin = plugin;
        this.random = new Random();
    }

    public void handleSpawn(LivingEntity entity) {
        if (!(entity instanceof Monster)) {
            return;
        }
        MobTier tier = this.determineTier();
        double maxHealth = entity.getAttribute(Attribute.MAX_HEALTH).getBaseValue() * tier.getHealthMult();
        entity.getAttribute(Attribute.MAX_HEALTH).setBaseValue(maxHealth);
        entity.setHealth(maxHealth);
        entity.getAttribute(Attribute.ATTACK_DAMAGE).setBaseValue(entity.getAttribute(Attribute.ATTACK_DAMAGE).getBaseValue() * tier.getDamageMult());
        Object name = entity.getType().name().replace("_", " ");
        name = ((String)name).substring(0, 1).toUpperCase() + ((String)name).substring(1).toLowerCase();
        entity.setCustomName(String.valueOf(tier.getColor()) + tier.name() + " " + (String)name);
        entity.setCustomNameVisible(true);
        entity.setMetadata("mob_tier", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)tier.name()));
    }

    private MobTier determineTier() {
        double roll = this.random.nextDouble();
        if (roll < 0.01) {
            return MobTier.BOSS;
        }
        if (roll < 0.05) {
            return MobTier.ELITE;
        }
        if (roll < 0.15) {
            return MobTier.MUTATED;
        }
        if (roll < 0.4) {
            return MobTier.ADVANCED;
        }
        return MobTier.COMMON;
    }

    public MobTier getMobTier(LivingEntity entity) {
        if (entity.hasMetadata("mob_tier")) {
            return MobTier.valueOf(((MetadataValue)entity.getMetadata("mob_tier").get(0)).asString());
        }
        return MobTier.COMMON;
    }
}

