/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.managers;

import com.dimensionrogue.DimensionRogue;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.plugin.Plugin;

public class LobbyManager
implements Listener {
    private final DimensionRogue plugin;
    private Location lobbySpawn;

    public LobbyManager(DimensionRogue plugin) {
        this.plugin = plugin;
        this.updateSpawnLocation();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.startLobbyEffects();
    }

    public void updateSpawnLocation() {
        World lobby = Bukkit.getWorld((String)this.plugin.getConfig().getString("server.lobby-world", "lobby"));
        if (lobby == null) {
            lobby = (World)Bukkit.getWorlds().get(0);
        }
        double x = this.plugin.getConfig().getDouble("lobby.spawn.x", 0.5);
        double y = this.plugin.getConfig().getDouble("lobby.spawn.y", 100.0);
        double z = this.plugin.getConfig().getDouble("lobby.spawn.z", 0.5);
        float yaw = (float)this.plugin.getConfig().getDouble("lobby.spawn.yaw", 0.0);
        float pitch = (float)this.plugin.getConfig().getDouble("lobby.spawn.pitch", 0.0);
        this.lobbySpawn = new Location(lobby, x, y, z, yaw, pitch);
        lobby.setSpawnLocation(this.lobbySpawn);
        this.plugin.getLogger().info("Lobby spawn set to: X=" + String.format("%.1f", x) + " Y=" + String.format("%.1f", y) + " Z=" + String.format("%.1f", z));
    }

    private void startLobbyEffects() {
        Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            if (this.lobbySpawn != null && this.lobbySpawn.getWorld() != null) {
                this.lobbySpawn.getWorld().spawnParticle(Particle.PORTAL, this.lobbySpawn.clone().add(0.0, 2.0, 0.0), 50, 1.0, 1.0, 1.0, 0.1);
                this.lobbySpawn.getWorld().spawnParticle(Particle.END_ROD, this.lobbySpawn.clone().add(0.0, 0.5, 0.0), 10, 0.5, 0.5, 0.5, 0.05);
            }
        }, 20L, 20L);
    }

    public Location getLobbySpawn() {
        return this.lobbySpawn.clone();
    }

    public boolean isInLobby(Player player) {
        return player.getWorld().equals((Object)this.lobbySpawn.getWorld());
    }

    public void sendToLobby(Player player) {
        player.teleport(this.lobbySpawn);
        player.setGameMode(GameMode.ADVENTURE);
        player.setHealth(20.0);
        player.setFoodLevel(20);
        player.getInventory().clear();
        this.plugin.getCustomItemManager().giveStarterItems(player);
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (this.isInLobby(event.getPlayer()) && !event.getPlayer().isOp()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        if (this.isInLobby(event.getPlayer()) && !event.getPlayer().isOp()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onDamage(EntityDamageEvent event) {
        Player player;
        if (event.getEntity() instanceof Player && this.isInLobby(player = (Player)event.getEntity())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onItemDrop(PlayerDropItemEvent event) {
        if (this.isInLobby(event.getPlayer())) {
            event.setCancelled(true);
        }
    }
}

