/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.managers;

import com.dimensionrogue.DimensionRogue;
import com.dimensionrogue.models.PlayerData;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.plugin.Plugin;

public class LeaderboardManager {
    private final DimensionRogue plugin;
    private final Location topLevelLoc;
    private final List<Entity> holograms = new ArrayList<Entity>();

    public LeaderboardManager(DimensionRogue plugin) {
        this.plugin = plugin;
        this.topLevelLoc = new Location((World)Bukkit.getWorlds().get(0), 0.5, 103.0, 0.5);
    }

    public void updateLeaderboards() {
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            this.holograms.forEach(Entity::remove);
            this.holograms.clear();
            this.spawnTopLevelHologram();
        });
    }

    private void spawnTopLevelHologram() {
        List topPlayers = this.plugin.getPlayerDataManager().getAllPlayerData().stream().sorted((p1, p2) -> Integer.compare(p2.getLevel(), p1.getLevel())).limit(5L).collect(Collectors.toList());
        this.spawnHologramLine(this.topLevelLoc.clone().add(0.0, 1.7999999999999998, 0.0), "\u00a7b\u00a7lTOP LEVELS");
        int rank = 1;
        for (PlayerData p : topPlayers) {
            this.spawnHologramLine(this.topLevelLoc.clone().add(0.0, 0.3 * (double)(6 - rank), 0.0), "\u00a7e#" + rank + " \u00a7f" + p.getName() + " \u00a77- Lvl " + p.getLevel());
            ++rank;
        }
    }

    private void spawnHologramLine(Location loc, String text) {
        ArmorStand as = (ArmorStand)loc.getWorld().spawnEntity(loc, EntityType.ARMOR_STAND);
        as.setVisible(false);
        as.setGravity(false);
        as.setCustomName(text);
        as.setCustomNameVisible(true);
        as.setMarker(true);
        this.holograms.add((Entity)as);
    }
}

