/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.managers;

import com.dimensionrogue.DimensionRogue;
import com.dimensionrogue.models.PlayerData;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class FriendManager {
    private final DimensionRogue plugin;
    private final Map<UUID, Set<UUID>> friendRequests;

    public FriendManager(DimensionRogue plugin) {
        this.plugin = plugin;
        this.friendRequests = new ConcurrentHashMap<UUID, Set<UUID>>();
    }

    public void sendRequest(Player sender, Player target) {
        if (sender.getUniqueId().equals(target.getUniqueId())) {
            sender.sendMessage("\u00a7cYou cannot add yourself!");
            return;
        }
        PlayerData senderData = this.plugin.getPlayerDataManager().getPlayerData(sender);
        if (senderData.getFriends().contains(target.getUniqueId())) {
            sender.sendMessage("\u00a7cYou are already friends with " + target.getName());
            return;
        }
        Set requests = this.friendRequests.computeIfAbsent(target.getUniqueId(), k -> new HashSet());
        if (requests.contains(sender.getUniqueId())) {
            sender.sendMessage("\u00a7cYou have already sent a request to " + target.getName());
            return;
        }
        requests.add(sender.getUniqueId());
        sender.sendMessage("\u00a7aFriend request sent to " + target.getName());
        target.sendMessage("\u00a7e" + sender.getName() + " \u00a77wants to be your friend.");
        target.sendMessage(((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"\u00a7a[ACCEPT]").hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"\u00a77Click to accept")))).clickEvent(ClickEvent.runCommand((String)("/friend accept " + sender.getName())))).append((Component)Component.text((String)" \u00a7c[DENY]"))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"\u00a77Click to deny")))).clickEvent(ClickEvent.runCommand((String)("/friend deny " + sender.getName()))));
    }

    public void acceptRequest(Player receiver, Player sender) {
        Set<UUID> requests = this.friendRequests.get(receiver.getUniqueId());
        if (requests == null || !requests.contains(sender.getUniqueId())) {
            receiver.sendMessage("\u00a7cNo request from " + sender.getName());
            return;
        }
        requests.remove(sender.getUniqueId());
        PlayerData receiverData = this.plugin.getPlayerDataManager().getPlayerData(receiver);
        PlayerData senderData = this.plugin.getPlayerDataManager().getPlayerData(sender);
        receiverData.getFriends().add(sender.getUniqueId());
        senderData.getFriends().add(receiver.getUniqueId());
        receiver.sendMessage("\u00a7aYou are now friends with " + sender.getName());
        sender.sendMessage("\u00a7aYou are now friends with " + receiver.getName());
    }

    public void denyRequest(Player receiver, Player sender) {
        Set<UUID> requests = this.friendRequests.get(receiver.getUniqueId());
        if (requests != null) {
            requests.remove(sender.getUniqueId());
        }
        receiver.sendMessage("\u00a7cDenied request from " + sender.getName());
        sender.sendMessage("\u00a7c" + receiver.getName() + " denied your friend request.");
    }

    public void removeFriend(Player player, UUID friendId) {
        PlayerData data = this.plugin.getPlayerDataManager().getPlayerData(player);
        if (data.getFriends().remove(friendId)) {
            player.sendMessage("\u00a7cRemoved friend.");
            Player friend = Bukkit.getPlayer((UUID)friendId);
            if (friend != null) {
                PlayerData friendData = this.plugin.getPlayerDataManager().getPlayerData(friend);
                friendData.getFriends().remove(player.getUniqueId());
                friend.sendMessage("\u00a7c" + player.getName() + " removed you from friends.");
            }
        } else {
            player.sendMessage("\u00a7cPlayer not in friend list.");
        }
    }

    public void listFriends(Player player) {
        PlayerData data = this.plugin.getPlayerDataManager().getPlayerData(player);
        if (data.getFriends().isEmpty()) {
            player.sendMessage("\u00a7cYou have no friends :(");
            return;
        }
        player.sendMessage("\u00a7d\u00a7lFRIENDS LIST:");
        for (UUID uuid : data.getFriends()) {
            String name = Bukkit.getOfflinePlayer((UUID)uuid).getName();
            boolean online = Bukkit.getPlayer((UUID)uuid) != null;
            player.sendMessage("\u00a77- " + (online ? "\u00a7a" : "\u00a7c") + name);
        }
    }
}

