/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.managers;

import com.dimensionrogue.DimensionRogue;
import com.dimensionrogue.models.DimensionData;
import com.dimensionrogue.models.PlayerData;
import com.dimensionrogue.worlds.DimensionGenerator;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.Plugin;

public class DimensionManager {
    private final DimensionRogue plugin;
    private final Map<UUID, DimensionData> loadedDimensions;
    private final Random random;

    public DimensionManager(DimensionRogue plugin) {
        this.plugin = plugin;
        this.loadedDimensions = new ConcurrentHashMap<UUID, DimensionData>();
        this.random = new Random();
    }

    public void loadDimension(UUID ownerId) {
        this.plugin.getDatabaseManager().loadDimensionData(ownerId).thenAccept(data -> {
            this.loadedDimensions.put(ownerId, (DimensionData)data);
            this.ensureWorldExists((DimensionData)data);
        });
    }

    private void ensureWorldExists(DimensionData data) {
        String worldName = data.getWorldName();
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            WorldCreator creator = new WorldCreator(worldName);
            creator.generator((ChunkGenerator)new DimensionGenerator(data));
            creator.environment(World.Environment.NORMAL);
            Bukkit.createWorld((WorldCreator)creator);
        }
    }

    public void teleportToDimension(Player player, UUID ownerId) {
        DimensionData data = this.loadedDimensions.get(ownerId);
        if (data == null) {
            this.loadDimension(ownerId);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.teleportToDimension(player, ownerId), 40L);
            return;
        }
        World world = Bukkit.getWorld((String)data.getWorldName());
        if (world == null) {
            this.ensureWorldExists(data);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.teleportToDimension(player, ownerId), 40L);
            return;
        }
        Location safeSpawn = this.findSafeSpawnInDimension(world);
        player.teleport(safeSpawn);
        player.sendMessage("\u00a7d\u2728 Welcome to your \u00a75Personal Dimension");
        player.playSound(safeSpawn, Sound.BLOCK_PORTAL_TRAVEL, 1.0f, 1.0f);
        data.updateLastAccessed();
    }

    private Location findSafeSpawnInDimension(World world) {
        int x = 0;
        int z = 0;
        for (int y = 100; y >= 50; --y) {
            Block block = world.getBlockAt(x, y, z);
            Block above = world.getBlockAt(x, y + 1, z);
            Block above2 = world.getBlockAt(x, y + 2, z);
            if (!block.getType().isSolid() || above.getType().isSolid() || above2.getType().isSolid()) continue;
            return new Location(world, (double)x + 0.5, (double)(y + 1), (double)z + 0.5);
        }
        return new Location(world, (double)x + 0.5, 70.0, (double)z + 0.5);
    }

    public DimensionData getDimensionData(UUID ownerId) {
        return this.loadedDimensions.get(ownerId);
    }

    public void upgradeDimensionSize(Player player) {
        PlayerData pData = this.plugin.getPlayerDataManager().getPlayerData(player);
        if (pData == null) {
            return;
        }
        DimensionData dData = this.loadedDimensions.get(pData.getDimensionId());
        if (dData == null) {
            return;
        }
        int cost = this.plugin.getConfig().getInt("dimensions.upgrade-cost.size", 1000);
        if (!this.plugin.getCurrencyManager().hasEnough(player, "fragments", cost)) {
            player.sendMessage("\u00a7cNot enough Fragments! Need: \u00a76" + cost);
            return;
        }
        this.plugin.getCurrencyManager().removeCurrency(player, "fragments", cost);
        dData.setSize(dData.getSize() + 100);
        dData.incrementSizeUpgrades();
        player.sendMessage("\u00a7aDimension size upgraded to \u00a76" + dData.getSize() + " blocks!");
    }

    public void triggerRandomEvents() {
        String[] events = new String[]{"Block Decay", "Meteor Strike", "Frozen Storm", "Mob Invasion", "Stability Meltdown", "Portal Surge", "Gravity Collapse"};
        for (DimensionData data : this.loadedDimensions.values()) {
            if (!(this.random.nextDouble() < 0.1) || data.getCurrentEvent() != null) continue;
            String event = events[this.random.nextInt(events.length)];
            data.setCurrentEvent(event);
            data.setEventEndTime(System.currentTimeMillis() + 900000L);
            World world = Bukkit.getWorld((String)data.getWorldName());
            if (world == null) continue;
            for (Player player : world.getPlayers()) {
                player.sendMessage("\u00a7c\u00a7l\u26a0 DIMENSION EVENT: \u00a7e" + event);
                player.playSound(player.getLocation(), Sound.ENTITY_ENDER_DRAGON_GROWL, 1.0f, 0.5f);
            }
        }
    }

    public void saveAllDimensions() {
        for (DimensionData data : this.loadedDimensions.values()) {
            this.plugin.getDatabaseManager().saveDimensionData(data);
        }
    }

    public boolean isDimensionWorld(World world) {
        if (world == null) {
            return false;
        }
        for (DimensionData data : this.loadedDimensions.values()) {
            if (!data.getWorldName().equals(world.getName())) continue;
            return true;
        }
        return false;
    }
}

