/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.managers;

import com.dimensionrogue.DimensionRogue;
import java.util.Arrays;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CustomItemManager {
    private final DimensionRogue plugin;

    public CustomItemManager(DimensionRogue plugin) {
        this.plugin = plugin;
    }

    public void giveStarterItems(Player player) {
        player.getInventory().clear();
        player.getInventory().setItem(0, this.createDimensionCompass());
        player.getInventory().setItem(1, this.createPortalSeeker());
        player.getInventory().setItem(2, this.createAbilityTome());
        player.getInventory().setItem(4, this.createShopToken());
        player.getInventory().setItem(8, this.createInfoBook());
    }

    private ItemStack createDimensionCompass() {
        ItemStack item = new ItemStack(Material.COMPASS);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(Component.text((String)"\u00a75\u00a7lDimension Compass").decoration(TextDecoration.ITALIC, false));
        meta.lore(Arrays.asList((TextComponent)Component.text((String)"\u00a77Right-click to teleport to").decoration(TextDecoration.ITALIC, false), (TextComponent)Component.text((String)"\u00a77your Personal Dimension").decoration(TextDecoration.ITALIC, false), (TextComponent)Component.text((String)"").decoration(TextDecoration.ITALIC, false), (TextComponent)Component.text((String)"\u00a7d\u00a7lRIGHT CLICK").decoration(TextDecoration.ITALIC, false)));
        meta.setCustomModelData(Integer.valueOf(1001));
        meta.addEnchant(Enchantment.UNBREAKING, 1, true);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createPortalSeeker() {
        ItemStack item = new ItemStack(Material.ENDER_EYE);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(Component.text((String)"\u00a7d\u00a7lPortal Seeker").decoration(TextDecoration.ITALIC, false));
        meta.lore(Arrays.asList((TextComponent)Component.text((String)"\u00a77Reveals nearby Void Rifts").decoration(TextDecoration.ITALIC, false), (TextComponent)Component.text((String)"\u00a77and portal locations").decoration(TextDecoration.ITALIC, false), (TextComponent)Component.text((String)"").decoration(TextDecoration.ITALIC, false), (TextComponent)Component.text((String)"\u00a7d\u00a7lRIGHT CLICK").decoration(TextDecoration.ITALIC, false)));
        meta.setCustomModelData(Integer.valueOf(1002));
        meta.addEnchant(Enchantment.UNBREAKING, 1, true);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createAbilityTome() {
        ItemStack item = new ItemStack(Material.ENCHANTED_BOOK);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(Component.text((String)"\u00a7b\u00a7lAbility Tome").decoration(TextDecoration.ITALIC, false));
        meta.lore(Arrays.asList((TextComponent)Component.text((String)"\u00a77Open to view and equip").decoration(TextDecoration.ITALIC, false), (TextComponent)Component.text((String)"\u00a77your unlocked abilities").decoration(TextDecoration.ITALIC, false), (TextComponent)Component.text((String)"").decoration(TextDecoration.ITALIC, false), (TextComponent)Component.text((String)"\u00a7d\u00a7lRIGHT CLICK").decoration(TextDecoration.ITALIC, false)));
        meta.setCustomModelData(Integer.valueOf(1003));
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createShopToken() {
        ItemStack item = new ItemStack(Material.EMERALD);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(Component.text((String)"\u00a7a\u00a7lShop Token").decoration(TextDecoration.ITALIC, false));
        meta.lore(Arrays.asList((TextComponent)Component.text((String)"\u00a77Right-click to open").decoration(TextDecoration.ITALIC, false), (TextComponent)Component.text((String)"\u00a77the Dimensional Shop").decoration(TextDecoration.ITALIC, false), (TextComponent)Component.text((String)"").decoration(TextDecoration.ITALIC, false), (TextComponent)Component.text((String)"\u00a7d\u00a7lRIGHT CLICK").decoration(TextDecoration.ITALIC, false)));
        meta.setCustomModelData(Integer.valueOf(1004));
        meta.addEnchant(Enchantment.UNBREAKING, 1, true);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createInfoBook() {
        ItemStack item = new ItemStack(Material.WRITTEN_BOOK);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(Component.text((String)"\u00a7e\u00a7lGuide Book").decoration(TextDecoration.ITALIC, false));
        meta.lore(Arrays.asList((TextComponent)Component.text((String)"\u00a77Read to learn about").decoration(TextDecoration.ITALIC, false), (TextComponent)Component.text((String)"\u00a77Dimension Rogue").decoration(TextDecoration.ITALIC, false)));
        meta.setCustomModelData(Integer.valueOf(1005));
        item.setItemMeta(meta);
        return item;
    }

    public boolean isDimensionCompass(ItemStack item) {
        return item != null && item.getType() == Material.COMPASS && item.hasItemMeta() && item.getItemMeta().hasCustomModelData() && item.getItemMeta().getCustomModelData() == 1001;
    }

    public boolean isPortalSeeker(ItemStack item) {
        return item != null && item.getType() == Material.ENDER_EYE && item.hasItemMeta() && item.getItemMeta().hasCustomModelData() && item.getItemMeta().getCustomModelData() == 1002;
    }

    public boolean isAbilityTome(ItemStack item) {
        return item != null && item.getType() == Material.ENCHANTED_BOOK && item.hasItemMeta() && item.getItemMeta().hasCustomModelData() && item.getItemMeta().getCustomModelData() == 1003;
    }

    public boolean isShopToken(ItemStack item) {
        return item != null && item.getType() == Material.EMERALD && item.hasItemMeta() && item.getItemMeta().hasCustomModelData() && item.getItemMeta().getCustomModelData() == 1004;
    }
}

