/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.managers;

import com.dimensionrogue.DimensionRogue;
import com.dimensionrogue.models.PlayerData;
import org.bukkit.entity.Player;

public class CurrencyManager {
    private final DimensionRogue plugin;

    public CurrencyManager(DimensionRogue plugin) {
        this.plugin = plugin;
    }

    public long getBalance(Player player, String type) {
        PlayerData data = this.plugin.getPlayerDataManager().getPlayerData(player);
        if (data == null) {
            return 0L;
        }
        return switch (type.toLowerCase()) {
            case "shards" -> data.getShards();
            case "fragments" -> data.getFragments();
            case "echoes" -> data.getEchoes();
            default -> 0L;
        };
    }

    public void addCurrency(Player player, String type, long amount) {
        PlayerData data = this.plugin.getPlayerDataManager().getPlayerData(player);
        if (data != null) {
            data.addCurrency(type, amount);
            player.sendMessage("\u00a7a+\u00a76" + amount + " \u00a7e" + type.toUpperCase());
        }
    }

    public boolean removeCurrency(Player player, String type, long amount) {
        PlayerData data = this.plugin.getPlayerDataManager().getPlayerData(player);
        if (data != null && data.removeCurrency(type, amount)) {
            player.sendMessage("\u00a7c-\u00a76" + amount + " \u00a7e" + type.toUpperCase());
            return true;
        }
        return false;
    }

    public boolean hasEnough(Player player, String type, long amount) {
        return this.getBalance(player, type) >= amount;
    }
}

