/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.managers;

import com.dimensionrogue.DimensionRogue;
import com.dimensionrogue.cosmetics.CosmeticType;
import com.dimensionrogue.models.PlayerData;
import com.dimensionrogue.utils.ParticleUtil;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class CosmeticsManager {
    private final DimensionRogue plugin;
    private BukkitTask particleTask;

    public CosmeticsManager(DimensionRogue plugin) {
        this.plugin = plugin;
        this.startParticleTask();
    }

    private void startParticleTask() {
        this.particleTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                PlayerData data = this.plugin.getPlayerDataManager().getPlayerData(player);
                if (data == null) continue;
                Map<String, String> equipped = data.getEquippedCosmetics();
                if (equipped.containsKey("WINGS")) {
                    String wingId = equipped.get("WINGS");
                    if (wingId.equals("angel_wings")) {
                        ParticleUtil.drawWings(player.getLocation(), Particle.END_ROD);
                    } else if (wingId.equals("demon_wings")) {
                        ParticleUtil.drawWings(player.getLocation(), Particle.FLAME);
                    }
                }
                if (equipped.containsKey("AURA")) {
                    String auraId = equipped.get("AURA");
                    if (auraId.equals("void_aura")) {
                        ParticleUtil.drawHelix(player.getLocation(), Particle.WITCH);
                    } else if (auraId.equals("holy_halo")) {
                        ParticleUtil.drawHalo(player.getLocation(), Particle.WAX_ON);
                    }
                }
                if (!equipped.containsKey("TRAIL") || !(player.getVelocity().length() > 0.1)) continue;
                String trailId = equipped.get("TRAIL");
                if (trailId.equals("fire_trail")) {
                    player.getWorld().spawnParticle(Particle.FLAME, player.getLocation(), 2, 0.2, 0.0, 0.2, 0.0);
                    continue;
                }
                if (!trailId.equals("heart_trail")) continue;
                player.getWorld().spawnParticle(Particle.HEART, player.getLocation(), 1, 0.2, 0.5, 0.2, 0.0);
            }
        }, 0L, 2L);
    }

    public void equipCosmetic(Player player, CosmeticType type, String id) {
        PlayerData data = this.plugin.getPlayerDataManager().getPlayerData(player);
        if (data != null) {
            data.getEquippedCosmetics().put(type.name(), id);
            player.sendMessage("\u00a7aEquipped " + id.replace("_", " "));
        }
    }

    public void unequipCosmetic(Player player, CosmeticType type) {
        PlayerData data = this.plugin.getPlayerDataManager().getPlayerData(player);
        if (data != null) {
            data.getEquippedCosmetics().remove(type.name());
            player.sendMessage("\u00a7cUnequipped " + type.name());
        }
    }
}

