/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.managers;

import com.dimensionrogue.DimensionRogue;
import com.dimensionrogue.models.PlayerData;
import io.papermc.paper.event.player.AsyncChatEvent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.entity.Player;

public class ChatManager {
    private final DimensionRogue plugin;

    public ChatManager(DimensionRogue plugin) {
        this.plugin = plugin;
    }

    public void handleChat(AsyncChatEvent event) {
        Player player = event.getPlayer();
        PlayerData data = this.plugin.getPlayerDataManager().getPlayerData(player);
        if (data == null) {
            return;
        }
        String rank = data.getRank();
        String prefix = this.getRankPrefix(rank);
        String message = LegacyComponentSerializer.legacyAmpersand().serialize(event.message());
        event.renderer((source, sourceDisplayName, msg, viewer) -> Component.text((String)(prefix + source.getName() + "\u00a78: \u00a7f")).append(msg));
    }

    private String getRankPrefix(String rank) {
        switch (rank.toUpperCase()) {
            case "GOD": {
                return "\u00a74\u00a7l[GOD] \u00a7c";
            }
            case "TITAN": {
                return "\u00a7c\u00a7l[TITAN] \u00a7c";
            }
            case "LORD": {
                return "\u00a76\u00a7l[LORD] \u00a7e";
            }
            case "CHAMPION": {
                return "\u00a7e\u00a7l[CHAMP] \u00a7e";
            }
            case "SLAYER": {
                return "\u00a7b\u00a7l[SLAYER] \u00a7b";
            }
            case "RAIDER": {
                return "\u00a73[Raider] \u00a73";
            }
            case "SCOUT": {
                return "\u00a7a[Scout] \u00a7a";
            }
        }
        return "\u00a77[Wanderer] \u00a77";
    }
}

