/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.managers;

import com.dimensionrogue.DimensionRogue;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class BossManager {
    private final DimensionRogue plugin;
    private final Random random = new Random();

    public BossManager(DimensionRogue plugin) {
        this.plugin = plugin;
    }

    public void spawnBoss(Location location, String type) {
        LivingEntity boss;
        switch (type.toUpperCase()) {
            case "VOID_KING": {
                boss = (LivingEntity)location.getWorld().spawnEntity(location, EntityType.WITHER_SKELETON);
                this.setupBoss(boss, "\u00a75\u00a7lVOID KING", 500.0, 20.0);
                break;
            }
            case "FLAME_LORD": {
                boss = (LivingEntity)location.getWorld().spawnEntity(location, EntityType.BLAZE);
                this.setupBoss(boss, "\u00a76\u00a7lFLAME LORD", 400.0, 15.0);
                break;
            }
            default: {
                boss = (LivingEntity)location.getWorld().spawnEntity(location, EntityType.ZOMBIE);
                this.setupBoss(boss, "\u00a7c\u00a7lBOSS", 300.0, 10.0);
            }
        }
        Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            if (boss.isDead() || !boss.isValid()) {
                return;
            }
            Player target = null;
            double minDist = 100.0;
            for (Player p : location.getWorld().getPlayers()) {
                double dist = p.getLocation().distance(boss.getLocation());
                if (!(dist < minDist)) continue;
                minDist = dist;
                target = p;
            }
            if (target != null && this.random.nextDouble() < 0.1) {
                this.useAbility(boss, target);
            }
        }, 20L, 20L);
    }

    private void setupBoss(LivingEntity boss, String name, double health, double damage) {
        boss.setCustomName(name);
        boss.setCustomNameVisible(true);
        boss.getAttribute(Attribute.valueOf((String)"GENERIC_MAX_HEALTH")).setBaseValue(health);
        boss.setHealth(health);
        boss.getAttribute(Attribute.valueOf((String)"GENERIC_ATTACK_DAMAGE")).setBaseValue(damage);
        boss.setRemoveWhenFarAway(false);
    }

    private void useAbility(LivingEntity boss, Player target) {
        boss.getWorld().playSound(boss.getLocation(), Sound.ENTITY_WITHER_SHOOT, 1.0f, 0.5f);
        target.sendMessage("\u00a7c" + boss.getCustomName() + " uses a special attack!");
        target.damage(5.0, (Entity)boss);
        target.setVelocity(target.getLocation().toVector().subtract(boss.getLocation().toVector()).normalize().multiply(2));
    }
}

