/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.managers;

import com.dimensionrogue.DimensionRogue;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;

public class AntiCheatManager
implements Listener {
    private final DimensionRogue plugin;
    private final Map<UUID, Long> lastAttackTime = new HashMap<UUID, Long>();
    private final Map<UUID, Integer> violationLevel = new HashMap<UUID, Integer>();

    public AntiCheatManager(DimensionRogue plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (player.getGameMode() == GameMode.CREATIVE || player.getGameMode() == GameMode.SPECTATOR || player.isFlying()) {
            return;
        }
        Location from = event.getFrom();
        Location to = event.getTo();
        if (to == null) {
            return;
        }
        double dist = from.distance(to);
        if (dist > 0.9 && !player.isGliding() && !player.isRiptiding() && player.getVehicle() == null) {
            this.flag(player, "Speed (Distance: " + String.format("%.2f", dist) + ")");
            event.setTo(from);
        }
        if (!(to.getY() > from.getY()) || player.isOnGround() || player.isGliding() || player.isClimbing() || player.isInWater() || player.getLocation().subtract(0.0, 1.0, 0.0).getBlock().getType() == Material.AIR) {
            // empty if block
        }
    }

    @EventHandler
    public void onCombat(EntityDamageByEntityEvent event) {
        if (!(event.getDamager() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getDamager();
        double reach = player.getLocation().distance(event.getEntity().getLocation());
        if (reach > 4.5) {
            this.flag(player, "Reach (Distance: " + String.format("%.2f", reach) + ")");
            event.setCancelled(true);
        }
        long last = this.lastAttackTime.getOrDefault(player.getUniqueId(), 0L);
        long now = System.currentTimeMillis();
        if (now - last < 50L) {
            this.flag(player, "Killaura (CPS)");
            event.setCancelled(true);
        }
        this.lastAttackTime.put(player.getUniqueId(), now);
    }

    private void flag(Player player, String check) {
        int vl = this.violationLevel.getOrDefault(player.getUniqueId(), 0) + 1;
        this.violationLevel.put(player.getUniqueId(), vl);
        String msg = "\u00a78[\u00a7cAC\u00a78] \u00a7c" + player.getName() + " \u00a77failed \u00a7c" + check + " \u00a77(VL: " + vl + ")";
        Bukkit.getConsoleSender().sendMessage(msg);
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (!p.hasPermission("dimensionrogue.admin")) continue;
            p.sendMessage(msg);
        }
        if (vl > 20) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                player.kickPlayer("\u00a7cUnfair Advantage Detected");
                Bukkit.broadcastMessage((String)("\u00a7c" + player.getName() + " was removed by Anti-Cheat."));
                this.violationLevel.remove(player.getUniqueId());
            });
        }
    }
}

