/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.managers;

import com.dimensionrogue.DimensionRogue;
import com.dimensionrogue.abilities.Ability;
import com.dimensionrogue.abilities.attack.VoidSlash;
import com.dimensionrogue.abilities.movement.BlinkDash;
import com.dimensionrogue.abilities.ultimate.TimeStop;
import com.dimensionrogue.models.PlayerData;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class AbilityManager {
    private final DimensionRogue plugin;
    private final Map<String, Ability> registeredAbilities;
    private final Map<UUID, Map<String, Long>> cooldowns;

    public AbilityManager(DimensionRogue plugin) {
        this.plugin = plugin;
        this.registeredAbilities = new HashMap<String, Ability>();
        this.cooldowns = new ConcurrentHashMap<UUID, Map<String, Long>>();
        this.registerAbilities();
    }

    private void registerAbilities() {
        this.register(new BlinkDash(this.plugin));
        this.register(new VoidSlash(this.plugin));
        this.register(new TimeStop(this.plugin));
    }

    private void register(Ability ability) {
        this.registeredAbilities.put(ability.getId(), ability);
    }

    public void useAbility(Player player, String abilityId) {
        Ability ability = this.registeredAbilities.get(abilityId);
        if (ability == null) {
            player.sendMessage("\u00a7cUnknown ability: " + abilityId);
            return;
        }
        if (this.isOnCooldown(player, abilityId)) {
            long remaining = this.getRemainingCooldown(player, abilityId);
            player.sendActionBar((Component)Component.text((String)("\u00a7cCooldown: " + String.format("%.1f", (double)remaining / 1000.0) + "s")));
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 0.5f);
            return;
        }
        PlayerData data = this.plugin.getPlayerDataManager().getPlayerData(player);
        int level = data != null ? data.getAbilityLevels().getOrDefault(abilityId, 1) : 1;
        ability.execute(player, level);
        this.setCooldown(player, abilityId, ability.getCooldown());
    }

    private boolean isOnCooldown(Player player, String abilityId) {
        Map<String, Long> playerCooldowns = this.cooldowns.get(player.getUniqueId());
        if (playerCooldowns == null) {
            return false;
        }
        return playerCooldowns.containsKey(abilityId) && playerCooldowns.get(abilityId) > System.currentTimeMillis();
    }

    private long getRemainingCooldown(Player player, String abilityId) {
        Map<String, Long> playerCooldowns = this.cooldowns.get(player.getUniqueId());
        if (playerCooldowns == null) {
            return 0L;
        }
        return Math.max(0L, playerCooldowns.get(abilityId) - System.currentTimeMillis());
    }

    private void setCooldown(Player player, String abilityId, long duration) {
        this.cooldowns.computeIfAbsent(player.getUniqueId(), k -> new ConcurrentHashMap()).put(abilityId, System.currentTimeMillis() + duration);
    }

    public Ability getAbility(String id) {
        return this.registeredAbilities.get(id);
    }
}

