/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.listeners;

import com.dimensionrogue.DimensionRogue;
import com.dimensionrogue.models.PlayerData;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class PlayerInteractListener
implements Listener {
    private final DimensionRogue plugin;

    public PlayerInteractListener(DimensionRogue plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item == null) {
            return;
        }
        if (this.plugin.getCustomItemManager().isDimensionCompass(item)) {
            event.setCancelled(true);
            PlayerData data = this.plugin.getPlayerDataManager().getPlayerData(player);
            if (data != null) {
                this.plugin.getDimensionManager().teleportToDimension(player, data.getDimensionId());
                player.playSound(player.getLocation(), Sound.BLOCK_PORTAL_TRAVEL, 1.0f, 1.0f);
            }
        } else if (this.plugin.getCustomItemManager().isPortalSeeker(item)) {
            event.setCancelled(true);
            player.sendMessage("\u00a7d[Portal Seeker] \u00a77Scanning for Void Rifts...");
            player.playSound(player.getLocation(), Sound.BLOCK_BEACON_ACTIVATE, 1.0f, 1.5f);
            player.sendMessage("\u00a77No portals detected nearby. Enter your dimension to find rifts!");
        } else if (this.plugin.getCustomItemManager().isAbilityTome(item)) {
            event.setCancelled(true);
            player.performCommand("abilities");
        } else if (this.plugin.getCustomItemManager().isShopToken(item)) {
            event.setCancelled(true);
            player.performCommand("shop");
        }
    }
}

