/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.listeners;

import com.dimensionrogue.DimensionRogue;
import com.dimensionrogue.mobs.MobTier;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntitySpawnEvent;

public class EntityListener
implements Listener {
    private final DimensionRogue plugin;

    public EntityListener(DimensionRogue plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onSpawn(EntitySpawnEvent event) {
        if (event.getEntity() instanceof LivingEntity) {
            this.plugin.getMobManager().handleSpawn((LivingEntity)event.getEntity());
        }
    }

    @EventHandler
    public void onDeath(EntityDeathEvent event) {
        LivingEntity entity = event.getEntity();
        MobTier tier = this.plugin.getMobManager().getMobTier(entity);
        if (tier != MobTier.COMMON) {
            int shards = (int)(10.0 * tier.getXpMult());
            if (entity.getKiller() != null) {
                this.plugin.getCurrencyManager().addCurrency(entity.getKiller(), "shards", shards);
                entity.getKiller().sendMessage("\u00a7e+" + shards + " Shards");
            }
        }
        event.setDroppedExp((int)((double)event.getDroppedExp() * tier.getXpMult()));
    }
}

