/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.management;

import com.dimensionrogue.libs.mongodb.connection.ConnectionId;
import com.dimensionrogue.libs.mongodb.connection.ServerId;
import com.dimensionrogue.libs.mongodb.event.ConnectionCheckedInEvent;
import com.dimensionrogue.libs.mongodb.event.ConnectionCheckedOutEvent;
import com.dimensionrogue.libs.mongodb.event.ConnectionClosedEvent;
import com.dimensionrogue.libs.mongodb.event.ConnectionCreatedEvent;
import com.dimensionrogue.libs.mongodb.event.ConnectionPoolClosedEvent;
import com.dimensionrogue.libs.mongodb.event.ConnectionPoolCreatedEvent;
import com.dimensionrogue.libs.mongodb.event.ConnectionPoolListener;
import com.dimensionrogue.libs.mongodb.lang.Nullable;
import com.dimensionrogue.libs.mongodb.management.ConnectionPoolStatistics;
import com.dimensionrogue.libs.mongodb.management.ConnectionPoolStatisticsMBean;
import com.dimensionrogue.libs.mongodb.management.MBeanServerFactory;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.ObjectName;

public class JMXConnectionPoolListener
implements ConnectionPoolListener {
    private final ConcurrentMap<ServerId, ConnectionPoolStatistics> map = new ConcurrentHashMap<ServerId, ConnectionPoolStatistics>();

    @Override
    public void connectionPoolCreated(ConnectionPoolCreatedEvent event) {
        ConnectionPoolStatistics statistics = new ConnectionPoolStatistics(event);
        this.map.put(event.getServerId(), statistics);
        MBeanServerFactory.getMBeanServer().registerMBean(statistics, this.getMBeanObjectName(event.getServerId()));
    }

    @Override
    public void connectionPoolClosed(ConnectionPoolClosedEvent event) {
        this.map.remove(event.getServerId());
        MBeanServerFactory.getMBeanServer().unregisterMBean(this.getMBeanObjectName(event.getServerId()));
    }

    @Override
    public void connectionCheckedOut(ConnectionCheckedOutEvent event) {
        ConnectionPoolStatistics statistics = this.getStatistics(event.getConnectionId());
        if (statistics != null) {
            statistics.connectionCheckedOut(event);
        }
    }

    @Override
    public void connectionCheckedIn(ConnectionCheckedInEvent event) {
        ConnectionPoolStatistics statistics = this.getStatistics(event.getConnectionId());
        if (statistics != null) {
            statistics.connectionCheckedIn(event);
        }
    }

    @Override
    public void connectionCreated(ConnectionCreatedEvent event) {
        ConnectionPoolStatistics statistics = this.getStatistics(event.getConnectionId());
        if (statistics != null) {
            statistics.connectionCreated(event);
        }
    }

    @Override
    public void connectionClosed(ConnectionClosedEvent event) {
        ConnectionPoolStatistics statistics = this.getStatistics(event.getConnectionId());
        if (statistics != null) {
            statistics.connectionClosed(event);
        }
    }

    String getMBeanObjectName(ServerId serverId) {
        String name = String.format("org.mongodb.driver:type=ConnectionPool,clusterId=%s,host=%s,port=%s", this.ensureValidValue(serverId.getClusterId().getValue()), this.ensureValidValue(serverId.getAddress().getHost()), serverId.getAddress().getPort());
        String clusterDescription = serverId.getClusterId().getDescription();
        if (clusterDescription != null) {
            name = String.format("%s,description=%s", name, this.ensureValidValue(clusterDescription));
        }
        return name;
    }

    @Nullable
    ConnectionPoolStatisticsMBean getMBean(ServerId serverId) {
        return this.getStatistics(serverId);
    }

    @Nullable
    private ConnectionPoolStatistics getStatistics(ConnectionId connectionId) {
        return this.getStatistics(connectionId.getServerId());
    }

    @Nullable
    private ConnectionPoolStatistics getStatistics(ServerId serverId) {
        return (ConnectionPoolStatistics)this.map.get(serverId);
    }

    private String ensureValidValue(String value) {
        if (this.containsQuotableCharacter(value)) {
            return ObjectName.quote(value);
        }
        return value;
    }

    private boolean containsQuotableCharacter(@Nullable String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        List<String> quoteableCharacters = Arrays.asList(",", ":", "?", "*", "=", "\"", "\\", "\n");
        for (String quotable : quoteableCharacters) {
            if (!value.contains(quotable)) continue;
            return true;
        }
        return false;
    }
}

