/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.internal.validator;

import com.dimensionrogue.libs.bson.FieldNameValidator;
import com.dimensionrogue.libs.mongodb.assertions.Assertions;
import com.dimensionrogue.libs.mongodb.internal.validator.NoOpFieldNameValidator;

public class UpdateFieldNameValidator
implements FieldNameValidator {
    private int numFields = 0;

    @Override
    public boolean validate(String fieldName) {
        ++this.numFields;
        return fieldName.startsWith("$");
    }

    @Override
    public String getValidationErrorMessage(String fieldName) {
        Assertions.assertFalse(fieldName.startsWith("$"));
        return String.format("All update operators must start with '$', but '%s' does not", fieldName);
    }

    @Override
    public FieldNameValidator getValidatorForField(String fieldName) {
        return new NoOpFieldNameValidator();
    }

    @Override
    public void start() {
        this.numFields = 0;
    }

    @Override
    public void end() {
        if (this.numFields == 0) {
            throw new IllegalArgumentException("Invalid BSON document for an update. The document may not be empty.");
        }
    }
}

