/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.internal.selector;

import com.dimensionrogue.libs.mongodb.ServerAddress;
import com.dimensionrogue.libs.mongodb.assertions.Assertions;
import com.dimensionrogue.libs.mongodb.connection.ClusterDescription;
import com.dimensionrogue.libs.mongodb.connection.ServerDescription;
import com.dimensionrogue.libs.mongodb.internal.connection.ClusterDescriptionHelper;
import com.dimensionrogue.libs.mongodb.selector.ServerSelector;
import java.util.Collections;
import java.util.List;

public class ServerAddressSelector
implements ServerSelector {
    private final ServerAddress serverAddress;

    public ServerAddressSelector(ServerAddress serverAddress) {
        this.serverAddress = Assertions.notNull("serverAddress", serverAddress);
    }

    public ServerAddress getServerAddress() {
        return this.serverAddress;
    }

    @Override
    public List<ServerDescription> select(ClusterDescription clusterDescription) {
        ServerDescription serverDescription = ClusterDescriptionHelper.getByServerAddress(clusterDescription, this.serverAddress);
        if (serverDescription != null) {
            return Collections.singletonList(serverDescription);
        }
        return Collections.emptyList();
    }

    public String toString() {
        return "ServerAddressSelector{serverAddress=" + this.serverAddress + '}';
    }
}

