/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.internal.operation.retry;

import com.dimensionrogue.libs.bson.BsonDocument;
import com.dimensionrogue.libs.mongodb.annotations.Immutable;
import com.dimensionrogue.libs.mongodb.assertions.Assertions;
import com.dimensionrogue.libs.mongodb.bulk.BulkWriteResult;
import com.dimensionrogue.libs.mongodb.internal.async.function.LoopState;
import com.dimensionrogue.libs.mongodb.internal.operation.MixedBulkWriteOperation;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;

public final class AttachmentKeys {
    private static final LoopState.AttachmentKey<Integer> MAX_WIRE_VERSION = new DefaultAttachmentKey<Integer>("maxWireVersion");
    private static final LoopState.AttachmentKey<BsonDocument> COMMAND = new DefaultAttachmentKey<BsonDocument>("command");
    private static final LoopState.AttachmentKey<Boolean> RETRYABLE_COMMAND_FLAG = new DefaultAttachmentKey<Boolean>("retryableCommandFlag");
    private static final LoopState.AttachmentKey<Supplier<String>> COMMAND_DESCRIPTION_SUPPLIER = new DefaultAttachmentKey<Supplier<String>>("commandDescriptionSupplier");
    private static final LoopState.AttachmentKey<MixedBulkWriteOperation.BulkWriteTracker> BULK_WRITE_TRACKER = new DefaultAttachmentKey<MixedBulkWriteOperation.BulkWriteTracker>("bulkWriteTracker");
    private static final LoopState.AttachmentKey<BulkWriteResult> BULK_WRITE_RESULT = new DefaultAttachmentKey<BulkWriteResult>("bulkWriteResult");

    public static LoopState.AttachmentKey<Integer> maxWireVersion() {
        return MAX_WIRE_VERSION;
    }

    public static LoopState.AttachmentKey<BsonDocument> command() {
        return COMMAND;
    }

    public static LoopState.AttachmentKey<Boolean> retryableCommandFlag() {
        return RETRYABLE_COMMAND_FLAG;
    }

    public static LoopState.AttachmentKey<Supplier<String>> commandDescriptionSupplier() {
        return COMMAND_DESCRIPTION_SUPPLIER;
    }

    public static LoopState.AttachmentKey<MixedBulkWriteOperation.BulkWriteTracker> bulkWriteTracker() {
        return BULK_WRITE_TRACKER;
    }

    public static LoopState.AttachmentKey<BulkWriteResult> bulkWriteResult() {
        return BULK_WRITE_RESULT;
    }

    private AttachmentKeys() {
        Assertions.fail();
    }

    @Immutable
    private static final class DefaultAttachmentKey<V>
    implements LoopState.AttachmentKey<V> {
        private static final Set<String> AVOID_KEY_DUPLICATION = new HashSet<String>();
        private final String key;

        private DefaultAttachmentKey(String key) {
            Assertions.assertTrue(AVOID_KEY_DUPLICATION.add(key));
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultAttachmentKey that = (DefaultAttachmentKey)o;
            return this.key.equals(that.key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public String toString() {
            return this.key;
        }
    }
}

