/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.internal.operation;

import com.dimensionrogue.libs.bson.BsonDocument;
import com.dimensionrogue.libs.bson.BsonInt32;
import com.dimensionrogue.libs.bson.codecs.BsonDocumentCodec;
import com.dimensionrogue.libs.mongodb.Function;
import com.dimensionrogue.libs.mongodb.WriteConcern;
import com.dimensionrogue.libs.mongodb.assertions.Assertions;
import com.dimensionrogue.libs.mongodb.internal.async.ErrorHandlingResultCallback;
import com.dimensionrogue.libs.mongodb.internal.async.SingleResultCallback;
import com.dimensionrogue.libs.mongodb.internal.binding.AsyncWriteBinding;
import com.dimensionrogue.libs.mongodb.internal.binding.WriteBinding;
import com.dimensionrogue.libs.mongodb.internal.operation.AsyncOperationHelper;
import com.dimensionrogue.libs.mongodb.internal.operation.AsyncWriteOperation;
import com.dimensionrogue.libs.mongodb.internal.operation.CommandOperationHelper;
import com.dimensionrogue.libs.mongodb.internal.operation.OperationHelper;
import com.dimensionrogue.libs.mongodb.internal.operation.SyncOperationHelper;
import com.dimensionrogue.libs.mongodb.internal.operation.WriteOperation;
import com.dimensionrogue.libs.mongodb.internal.validator.NoOpFieldNameValidator;

public abstract class TransactionOperation
implements WriteOperation<Void>,
AsyncWriteOperation<Void> {
    private final WriteConcern writeConcern;

    TransactionOperation(WriteConcern writeConcern) {
        this.writeConcern = Assertions.notNull("writeConcern", writeConcern);
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    @Override
    public Void execute(WriteBinding binding) {
        Assertions.isTrue("in transaction", binding.getSessionContext().hasActiveTransaction());
        return SyncOperationHelper.executeRetryableWrite(binding, "admin", null, new NoOpFieldNameValidator(), new BsonDocumentCodec(), this.getCommandCreator(), SyncOperationHelper.writeConcernErrorTransformer(), this.getRetryCommandModifier());
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, SingleResultCallback<Void> callback) {
        Assertions.isTrue("in transaction", binding.getSessionContext().hasActiveTransaction());
        AsyncOperationHelper.executeRetryableWriteAsync(binding, "admin", null, new NoOpFieldNameValidator(), new BsonDocumentCodec(), this.getCommandCreator(), AsyncOperationHelper.writeConcernErrorTransformerAsync(), this.getRetryCommandModifier(), ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER));
    }

    CommandOperationHelper.CommandCreator getCommandCreator() {
        return (serverDescription, connectionDescription) -> {
            BsonDocument command = new BsonDocument(this.getCommandName(), new BsonInt32(1));
            if (!this.writeConcern.isServerDefault()) {
                command.put("writeConcern", this.writeConcern.asDocument());
            }
            return command;
        };
    }

    protected abstract String getCommandName();

    protected abstract Function<BsonDocument, BsonDocument> getRetryCommandModifier();
}

