/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.internal.operation;

import com.dimensionrogue.libs.bson.BsonDocument;
import com.dimensionrogue.libs.bson.BsonValue;
import com.dimensionrogue.libs.bson.FieldNameValidator;
import com.dimensionrogue.libs.bson.codecs.BsonDocumentCodec;
import com.dimensionrogue.libs.bson.codecs.Decoder;
import com.dimensionrogue.libs.mongodb.Function;
import com.dimensionrogue.libs.mongodb.MongoException;
import com.dimensionrogue.libs.mongodb.ReadPreference;
import com.dimensionrogue.libs.mongodb.ServerAddress;
import com.dimensionrogue.libs.mongodb.assertions.Assertions;
import com.dimensionrogue.libs.mongodb.internal.async.function.RetryState;
import com.dimensionrogue.libs.mongodb.internal.async.function.RetryingSyncSupplier;
import com.dimensionrogue.libs.mongodb.internal.binding.ConnectionSource;
import com.dimensionrogue.libs.mongodb.internal.binding.ReadBinding;
import com.dimensionrogue.libs.mongodb.internal.binding.ReferenceCounted;
import com.dimensionrogue.libs.mongodb.internal.binding.WriteBinding;
import com.dimensionrogue.libs.mongodb.internal.connection.Connection;
import com.dimensionrogue.libs.mongodb.internal.connection.OperationContext;
import com.dimensionrogue.libs.mongodb.internal.connection.QueryResult;
import com.dimensionrogue.libs.mongodb.internal.operation.BatchCursor;
import com.dimensionrogue.libs.mongodb.internal.operation.CommandOperationHelper;
import com.dimensionrogue.libs.mongodb.internal.operation.OperationHelper;
import com.dimensionrogue.libs.mongodb.internal.operation.QueryBatchCursor;
import com.dimensionrogue.libs.mongodb.internal.operation.WriteConcernHelper;
import com.dimensionrogue.libs.mongodb.internal.operation.retry.AttachmentKeys;
import com.dimensionrogue.libs.mongodb.internal.validator.NoOpFieldNameValidator;
import com.dimensionrogue.libs.mongodb.lang.Nullable;
import java.util.function.BiFunction;
import java.util.function.Supplier;

final class SyncOperationHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T withReadConnectionSource(ReadBinding binding, CallableWithSource<T> callable) {
        ConnectionSource source = binding.getReadConnectionSource();
        try {
            T t = callable.call(source);
            return t;
        }
        finally {
            source.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T withConnection(WriteBinding binding, CallableWithConnection<T> callable) {
        ConnectionSource source = binding.getWriteConnectionSource();
        try {
            T t = SyncOperationHelper.withConnectionSource(source, callable);
            return t;
        }
        finally {
            source.release();
        }
    }

    static <R> R withSourceAndConnection(Supplier<ConnectionSource> sourceSupplier, boolean wrapConnectionSourceException, BiFunction<ConnectionSource, Connection, R> function) throws OperationHelper.ResourceSupplierInternalException {
        return (R)SyncOperationHelper.withSuppliedResource(sourceSupplier, wrapConnectionSourceException, source -> SyncOperationHelper.withSuppliedResource(source::getConnection, wrapConnectionSourceException, connection -> function.apply((ConnectionSource)source, (Connection)connection)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <R, T extends ReferenceCounted> R withSuppliedResource(Supplier<T> resourceSupplier, boolean wrapSupplierException, java.util.function.Function<T, R> function) throws OperationHelper.ResourceSupplierInternalException {
        ReferenceCounted resource = null;
        try {
            try {
                resource = (ReferenceCounted)resourceSupplier.get();
            }
            catch (Exception supplierException) {
                if (wrapSupplierException) {
                    throw new OperationHelper.ResourceSupplierInternalException(supplierException);
                }
                throw supplierException;
            }
            R r = function.apply(resource);
            return r;
        }
        finally {
            if (resource != null) {
                resource.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T withConnectionSource(ConnectionSource source, CallableWithConnection<T> callable) {
        Connection connection = source.getConnection();
        try {
            T t = callable.call(connection);
            return t;
        }
        finally {
            connection.release();
        }
    }

    static <D, T> T executeRetryableRead(ReadBinding binding, String database, CommandOperationHelper.CommandCreator commandCreator, Decoder<D> decoder, CommandReadTransformer<D, T> transformer, boolean retryReads) {
        return SyncOperationHelper.executeRetryableRead(binding, binding::getReadConnectionSource, database, commandCreator, decoder, transformer, retryReads);
    }

    static <D, T> T executeRetryableRead(ReadBinding binding, Supplier<ConnectionSource> readConnectionSourceSupplier, String database, CommandOperationHelper.CommandCreator commandCreator, Decoder<D> decoder, CommandReadTransformer<D, T> transformer, boolean retryReads) {
        RetryState retryState = CommandOperationHelper.initialRetryState(retryReads);
        Supplier<Object> read = SyncOperationHelper.decorateReadWithRetries(retryState, binding.getOperationContext(), () -> SyncOperationHelper.withSourceAndConnection(readConnectionSourceSupplier, false, (source, connection) -> {
            retryState.breakAndThrowIfRetryAnd(() -> !OperationHelper.canRetryRead(source.getServerDescription(), binding.getSessionContext()));
            return SyncOperationHelper.createReadCommandAndExecute(retryState, binding, source, database, commandCreator, decoder, transformer, connection);
        }));
        return (T)read.get();
    }

    static <D, T> T executeCommand(WriteBinding binding, String database, BsonDocument command, Decoder<D> decoder, CommandWriteTransformer<D, T> transformer) {
        return (T)SyncOperationHelper.withSourceAndConnection(binding::getWriteConnectionSource, false, (source, connection) -> transformer.apply((Object)Assertions.assertNotNull(connection.command(database, command, new NoOpFieldNameValidator(), ReadPreference.primary(), decoder, binding)), (Connection)connection));
    }

    @Nullable
    static <T> T executeCommand(WriteBinding binding, String database, BsonDocument command, Connection connection, CommandWriteTransformer<BsonDocument, T> transformer) {
        Assertions.notNull("binding", binding);
        return transformer.apply(Assertions.assertNotNull(connection.command(database, command, new NoOpFieldNameValidator(), ReadPreference.primary(), new BsonDocumentCodec(), binding)), connection);
    }

    static <T, R> R executeRetryableWrite(WriteBinding binding, String database, @Nullable ReadPreference readPreference, FieldNameValidator fieldNameValidator, Decoder<T> commandResultDecoder, CommandOperationHelper.CommandCreator commandCreator, CommandWriteTransformer<T, R> transformer, Function<BsonDocument, BsonDocument> retryCommandModifier) {
        RetryState retryState = CommandOperationHelper.initialRetryState(true);
        Supplier<Object> retryingWrite = SyncOperationHelper.decorateWriteWithRetries(retryState, binding.getOperationContext(), () -> {
            boolean firstAttempt = retryState.isFirstAttempt();
            if (!firstAttempt && binding.getSessionContext().hasActiveTransaction()) {
                binding.getSessionContext().clearTransactionContext();
            }
            return SyncOperationHelper.withSourceAndConnection(binding::getWriteConnectionSource, true, (source, connection) -> {
                int maxWireVersion = connection.getDescription().getMaxWireVersion();
                try {
                    retryState.breakAndThrowIfRetryAnd(() -> !OperationHelper.canRetryWrite(connection.getDescription(), binding.getSessionContext()));
                    BsonDocument command = retryState.attachment(AttachmentKeys.command()).map(previousAttemptCommand -> {
                        Assertions.assertFalse(firstAttempt);
                        return (BsonDocument)retryCommandModifier.apply((BsonDocument)previousAttemptCommand);
                    }).orElseGet(() -> commandCreator.create(source.getServerDescription(), connection.getDescription()));
                    retryState.attach(AttachmentKeys.maxWireVersion(), maxWireVersion, true).attach(AttachmentKeys.retryableCommandFlag(), CommandOperationHelper.isRetryWritesEnabled(command), true).attach(AttachmentKeys.commandDescriptionSupplier(), command::getFirstKey, false).attach(AttachmentKeys.command(), command, false);
                    return transformer.apply(Assertions.assertNotNull(connection.command(database, command, fieldNameValidator, readPreference, commandResultDecoder, binding)), (Connection)connection);
                }
                catch (MongoException e) {
                    if (!firstAttempt) {
                        CommandOperationHelper.addRetryableWriteErrorLabel(e, maxWireVersion);
                    }
                    throw e;
                }
            });
        });
        try {
            return (R)retryingWrite.get();
        }
        catch (MongoException e) {
            throw CommandOperationHelper.transformWriteException(e);
        }
    }

    @Nullable
    static <D, T> T createReadCommandAndExecute(RetryState retryState, ReadBinding binding, ConnectionSource source, String database, CommandOperationHelper.CommandCreator commandCreator, Decoder<D> decoder, CommandReadTransformer<D, T> transformer, Connection connection) {
        BsonDocument command = commandCreator.create(source.getServerDescription(), connection.getDescription());
        retryState.attach(AttachmentKeys.commandDescriptionSupplier(), command::getFirstKey, false);
        return transformer.apply(Assertions.assertNotNull(connection.command(database, command, new NoOpFieldNameValidator(), source.getReadPreference(), decoder, binding)), source, connection);
    }

    static <R> Supplier<R> decorateWriteWithRetries(RetryState retryState, OperationContext operationContext, Supplier<R> writeFunction) {
        return new RetryingSyncSupplier<Object>(retryState, CommandOperationHelper::chooseRetryableWriteException, CommandOperationHelper::shouldAttemptToRetryWrite, () -> {
            CommandOperationHelper.logRetryExecute(retryState, operationContext);
            return writeFunction.get();
        });
    }

    static <R> Supplier<R> decorateReadWithRetries(RetryState retryState, OperationContext operationContext, Supplier<R> readFunction) {
        return new RetryingSyncSupplier<Object>(retryState, CommandOperationHelper::chooseRetryableReadException, CommandOperationHelper::shouldAttemptToRetryRead, () -> {
            CommandOperationHelper.logRetryExecute(retryState, operationContext);
            return readFunction.get();
        });
    }

    static CommandWriteTransformer<BsonDocument, Void> writeConcernErrorTransformer() {
        return (result, connection) -> {
            Assertions.assertNotNull(result);
            WriteConcernHelper.throwOnWriteConcernError(result, connection.getDescription().getServerAddress(), connection.getDescription().getMaxWireVersion());
            return null;
        };
    }

    static <T> BatchCursor<T> cursorDocumentToBatchCursor(BsonDocument cursorDocument, Decoder<T> decoder, BsonValue comment, ConnectionSource source, Connection connection, int batchSize) {
        return new QueryBatchCursor(OperationHelper.cursorDocumentToQueryResult(cursorDocument, source.getServerDescription().getAddress()), 0, batchSize, 0L, decoder, comment, source, connection);
    }

    static <T> QueryResult<T> getMoreCursorDocumentToQueryResult(BsonDocument cursorDocument, ServerAddress serverAddress) {
        return OperationHelper.cursorDocumentToQueryResult(cursorDocument, serverAddress, "nextBatch");
    }

    private SyncOperationHelper() {
    }

    static interface CallableWithSource<T> {
        public T call(ConnectionSource var1);
    }

    static interface CallableWithConnection<T> {
        public T call(Connection var1);
    }

    static interface CommandReadTransformer<T, R> {
        @Nullable
        public R apply(T var1, ConnectionSource var2, Connection var3);
    }

    static interface CommandWriteTransformer<T, R> {
        @Nullable
        public R apply(T var1, Connection var2);
    }
}

