/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.internal.operation;

import com.dimensionrogue.libs.bson.BsonDocument;
import com.dimensionrogue.libs.bson.BsonString;
import com.dimensionrogue.libs.bson.BsonValue;
import com.dimensionrogue.libs.bson.codecs.Decoder;
import com.dimensionrogue.libs.mongodb.ExplainVerbosity;
import com.dimensionrogue.libs.mongodb.MongoCommandException;
import com.dimensionrogue.libs.mongodb.MongoNamespace;
import com.dimensionrogue.libs.mongodb.client.model.Collation;
import com.dimensionrogue.libs.mongodb.internal.async.AsyncBatchCursor;
import com.dimensionrogue.libs.mongodb.internal.async.SingleResultCallback;
import com.dimensionrogue.libs.mongodb.internal.binding.AsyncReadBinding;
import com.dimensionrogue.libs.mongodb.internal.binding.ReadBinding;
import com.dimensionrogue.libs.mongodb.internal.operation.AggregateOperation;
import com.dimensionrogue.libs.mongodb.internal.operation.AsyncExplainableReadOperation;
import com.dimensionrogue.libs.mongodb.internal.operation.AsyncOperationHelper;
import com.dimensionrogue.libs.mongodb.internal.operation.AsyncReadOperation;
import com.dimensionrogue.libs.mongodb.internal.operation.BatchCursor;
import com.dimensionrogue.libs.mongodb.internal.operation.CommandOperationHelper;
import com.dimensionrogue.libs.mongodb.internal.operation.ExplainableReadOperation;
import com.dimensionrogue.libs.mongodb.internal.operation.OperationHelper;
import com.dimensionrogue.libs.mongodb.internal.operation.ReadOperation;
import com.dimensionrogue.libs.mongodb.lang.NonNull;
import com.dimensionrogue.libs.mongodb.lang.Nullable;
import java.util.Collections;
import java.util.concurrent.TimeUnit;

final class ListSearchIndexesOperation<T>
implements AsyncExplainableReadOperation<AsyncBatchCursor<T>>,
ExplainableReadOperation<BatchCursor<T>> {
    private static final String STAGE_LIST_SEARCH_INDEXES = "$listSearchIndexes";
    private final MongoNamespace namespace;
    private final Decoder<T> decoder;
    @Nullable
    private final Boolean allowDiskUse;
    @Nullable
    private final Integer batchSize;
    @Nullable
    private final Collation collation;
    @Nullable
    private final BsonValue comment;
    private final long maxTimeMS;
    @Nullable
    private final String indexName;
    private final boolean retryReads;

    ListSearchIndexesOperation(MongoNamespace namespace, Decoder<T> decoder, long maxTimeMS, @Nullable String indexName, @Nullable Integer batchSize, @Nullable Collation collation, @Nullable BsonValue comment, @Nullable Boolean allowDiskUse, boolean retryReads) {
        this.namespace = namespace;
        this.decoder = decoder;
        this.allowDiskUse = allowDiskUse;
        this.batchSize = batchSize;
        this.collation = collation;
        this.maxTimeMS = maxTimeMS;
        this.comment = comment;
        this.indexName = indexName;
        this.retryReads = retryReads;
    }

    @Override
    public BatchCursor<T> execute(ReadBinding binding) {
        try {
            return this.asAggregateOperation().execute(binding);
        }
        catch (MongoCommandException exception) {
            int cursorBatchSize;
            int n = cursorBatchSize = this.batchSize == null ? 0 : this.batchSize;
            if (!CommandOperationHelper.isNamespaceError(exception)) {
                throw exception;
            }
            return OperationHelper.createEmptyBatchCursor(this.namespace, this.decoder, exception.getServerAddress(), cursorBatchSize);
        }
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, SingleResultCallback<AsyncBatchCursor<T>> callback) {
        this.asAggregateOperation().executeAsync(binding, (AsyncBatchCursor<T> cursor, Throwable exception) -> {
            if (exception != null && !CommandOperationHelper.isNamespaceError(exception)) {
                callback.onResult(null, exception);
            } else if (exception != null) {
                MongoCommandException commandException = (MongoCommandException)exception;
                AsyncBatchCursor emptyAsyncBatchCursor = AsyncOperationHelper.createEmptyAsyncBatchCursor(this.namespace, commandException.getServerAddress());
                callback.onResult(emptyAsyncBatchCursor, null);
            } else {
                callback.onResult((AsyncBatchCursor<T>)cursor, null);
            }
        });
    }

    @Override
    public <R> ReadOperation<R> asExplainableOperation(@Nullable ExplainVerbosity verbosity, Decoder<R> resultDecoder) {
        return this.asAggregateOperation().asExplainableOperation(verbosity, resultDecoder);
    }

    @Override
    public <R> AsyncReadOperation<R> asAsyncExplainableOperation(@Nullable ExplainVerbosity verbosity, Decoder<R> resultDecoder) {
        return this.asAggregateOperation().asAsyncExplainableOperation(verbosity, resultDecoder);
    }

    private AggregateOperation<T> asAggregateOperation() {
        BsonDocument searchDefinition = this.getSearchDefinition();
        BsonDocument listSearchIndexesStage = new BsonDocument(STAGE_LIST_SEARCH_INDEXES, searchDefinition);
        return new AggregateOperation<T>(this.namespace, Collections.singletonList(listSearchIndexesStage), this.decoder).retryReads(this.retryReads).collation(this.collation).comment(this.comment).allowDiskUse(this.allowDiskUse).batchSize(this.batchSize).maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    @NonNull
    private BsonDocument getSearchDefinition() {
        if (this.indexName == null) {
            return new BsonDocument();
        }
        return new BsonDocument("name", new BsonString(this.indexName));
    }
}

