/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.internal.operation;

import com.dimensionrogue.libs.bson.BsonBoolean;
import com.dimensionrogue.libs.bson.BsonDocument;
import com.dimensionrogue.libs.bson.BsonValue;
import com.dimensionrogue.libs.bson.FieldNameValidator;
import com.dimensionrogue.libs.bson.codecs.Decoder;
import com.dimensionrogue.libs.bson.conversions.Bson;
import com.dimensionrogue.libs.mongodb.MongoNamespace;
import com.dimensionrogue.libs.mongodb.WriteConcern;
import com.dimensionrogue.libs.mongodb.assertions.Assertions;
import com.dimensionrogue.libs.mongodb.client.model.Collation;
import com.dimensionrogue.libs.mongodb.connection.ConnectionDescription;
import com.dimensionrogue.libs.mongodb.internal.operation.BaseFindAndModifyOperation;
import com.dimensionrogue.libs.mongodb.internal.operation.DocumentHelper;
import com.dimensionrogue.libs.mongodb.internal.validator.MappedFieldNameValidator;
import com.dimensionrogue.libs.mongodb.internal.validator.NoOpFieldNameValidator;
import com.dimensionrogue.libs.mongodb.internal.validator.ReplacingDocumentFieldNameValidator;
import com.dimensionrogue.libs.mongodb.lang.Nullable;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;

public class FindAndReplaceOperation<T>
extends BaseFindAndModifyOperation<T> {
    private final BsonDocument replacement;
    private boolean returnOriginal = true;
    private boolean upsert;
    private Boolean bypassDocumentValidation;

    public FindAndReplaceOperation(MongoNamespace namespace, WriteConcern writeConcern, boolean retryWrites, Decoder<T> decoder, BsonDocument replacement) {
        super(namespace, writeConcern, retryWrites, decoder);
        this.replacement = Assertions.notNull("replacement", replacement);
    }

    public BsonDocument getReplacement() {
        return this.replacement;
    }

    public boolean isReturnOriginal() {
        return this.returnOriginal;
    }

    public FindAndReplaceOperation<T> returnOriginal(boolean returnOriginal) {
        this.returnOriginal = returnOriginal;
        return this;
    }

    public boolean isUpsert() {
        return this.upsert;
    }

    public FindAndReplaceOperation<T> upsert(boolean upsert) {
        this.upsert = upsert;
        return this;
    }

    public Boolean getBypassDocumentValidation() {
        return this.bypassDocumentValidation;
    }

    public FindAndReplaceOperation<T> bypassDocumentValidation(@Nullable Boolean bypassDocumentValidation) {
        this.bypassDocumentValidation = bypassDocumentValidation;
        return this;
    }

    @Override
    public FindAndReplaceOperation<T> filter(@Nullable BsonDocument filter) {
        super.filter(filter);
        return this;
    }

    @Override
    public FindAndReplaceOperation<T> projection(@Nullable BsonDocument projection) {
        super.projection(projection);
        return this;
    }

    @Override
    public FindAndReplaceOperation<T> maxTime(long maxTime, TimeUnit timeUnit) {
        super.maxTime(maxTime, timeUnit);
        return this;
    }

    @Override
    public FindAndReplaceOperation<T> sort(@Nullable BsonDocument sort) {
        super.sort(sort);
        return this;
    }

    @Override
    public FindAndReplaceOperation<T> hint(@Nullable Bson hint) {
        super.hint(hint);
        return this;
    }

    @Override
    public FindAndReplaceOperation<T> hintString(@Nullable String hint) {
        super.hintString(hint);
        return this;
    }

    @Override
    public FindAndReplaceOperation<T> collation(@Nullable Collation collation) {
        super.collation(collation);
        return this;
    }

    @Override
    public FindAndReplaceOperation<T> comment(@Nullable BsonValue comment) {
        super.comment(comment);
        return this;
    }

    @Override
    public FindAndReplaceOperation<T> let(@Nullable BsonDocument variables) {
        super.let(variables);
        return this;
    }

    @Override
    protected FieldNameValidator getFieldNameValidator() {
        HashMap<String, FieldNameValidator> map = new HashMap<String, FieldNameValidator>();
        map.put("update", new ReplacingDocumentFieldNameValidator());
        return new MappedFieldNameValidator(new NoOpFieldNameValidator(), map);
    }

    @Override
    protected void specializeCommand(BsonDocument commandDocument, ConnectionDescription connectionDescription) {
        commandDocument.put("new", new BsonBoolean(!this.isReturnOriginal()));
        DocumentHelper.putIfTrue(commandDocument, "upsert", this.isUpsert());
        commandDocument.put("update", this.getReplacement());
        if (this.bypassDocumentValidation != null) {
            commandDocument.put("bypassDocumentValidation", BsonBoolean.valueOf(this.bypassDocumentValidation));
        }
    }
}

