/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.internal.operation;

import com.dimensionrogue.libs.bson.BsonDocument;
import com.dimensionrogue.libs.bson.BsonString;
import com.dimensionrogue.libs.mongodb.ExplainVerbosity;
import com.dimensionrogue.libs.mongodb.MongoInternalException;
import com.dimensionrogue.libs.mongodb.lang.Nullable;

final class ExplainHelper {
    static BsonDocument asExplainCommand(BsonDocument command, @Nullable ExplainVerbosity explainVerbosity) {
        BsonDocument explainCommand = new BsonDocument("explain", command);
        if (explainVerbosity != null) {
            explainCommand.append("verbosity", ExplainHelper.getVerbosityAsString(explainVerbosity));
        }
        return explainCommand;
    }

    private static BsonString getVerbosityAsString(ExplainVerbosity explainVerbosity) {
        switch (explainVerbosity) {
            case QUERY_PLANNER: {
                return new BsonString("queryPlanner");
            }
            case EXECUTION_STATS: {
                return new BsonString("executionStats");
            }
            case ALL_PLANS_EXECUTIONS: {
                return new BsonString("allPlansExecution");
            }
        }
        throw new MongoInternalException(String.format("Unsupported explain verbosity %s", new Object[]{explainVerbosity}));
    }

    private ExplainHelper() {
    }
}

