/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.internal.operation;

import com.dimensionrogue.libs.bson.BsonDocument;
import com.dimensionrogue.libs.bson.BsonString;
import com.dimensionrogue.libs.bson.BsonValue;
import com.dimensionrogue.libs.bson.codecs.BsonDocumentCodec;
import com.dimensionrogue.libs.bson.codecs.Decoder;
import com.dimensionrogue.libs.mongodb.MongoCommandException;
import com.dimensionrogue.libs.mongodb.MongoNamespace;
import com.dimensionrogue.libs.mongodb.assertions.Assertions;
import com.dimensionrogue.libs.mongodb.connection.ConnectionDescription;
import com.dimensionrogue.libs.mongodb.internal.async.SingleResultCallback;
import com.dimensionrogue.libs.mongodb.internal.binding.AsyncReadBinding;
import com.dimensionrogue.libs.mongodb.internal.binding.ReadBinding;
import com.dimensionrogue.libs.mongodb.internal.operation.AsyncOperationHelper;
import com.dimensionrogue.libs.mongodb.internal.operation.AsyncReadOperation;
import com.dimensionrogue.libs.mongodb.internal.operation.CommandOperationHelper;
import com.dimensionrogue.libs.mongodb.internal.operation.CommandResultDocumentCodec;
import com.dimensionrogue.libs.mongodb.internal.operation.DocumentHelper;
import com.dimensionrogue.libs.mongodb.internal.operation.OperationReadConcernHelper;
import com.dimensionrogue.libs.mongodb.internal.operation.ReadOperation;
import com.dimensionrogue.libs.mongodb.internal.operation.SyncOperationHelper;
import com.dimensionrogue.libs.mongodb.internal.session.SessionContext;
import com.dimensionrogue.libs.mongodb.lang.Nullable;
import java.util.Collections;
import java.util.concurrent.TimeUnit;

public class EstimatedDocumentCountOperation
implements AsyncReadOperation<Long>,
ReadOperation<Long> {
    private static final Decoder<BsonDocument> DECODER = new BsonDocumentCodec();
    private final MongoNamespace namespace;
    private boolean retryReads;
    private long maxTimeMS;
    private BsonValue comment;

    public EstimatedDocumentCountOperation(MongoNamespace namespace) {
        this.namespace = Assertions.notNull("namespace", namespace);
    }

    public EstimatedDocumentCountOperation retryReads(boolean retryReads) {
        this.retryReads = retryReads;
        return this;
    }

    public EstimatedDocumentCountOperation maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Nullable
    public BsonValue getComment() {
        return this.comment;
    }

    public EstimatedDocumentCountOperation comment(@Nullable BsonValue comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public Long execute(ReadBinding binding) {
        try {
            return SyncOperationHelper.executeRetryableRead(binding, this.namespace.getDatabaseName(), this.getCommandCreator(binding.getSessionContext()), CommandResultDocumentCodec.create(DECODER, Collections.singletonList("firstBatch")), this.transformer(), this.retryReads);
        }
        catch (MongoCommandException e) {
            return Assertions.assertNotNull(CommandOperationHelper.rethrowIfNotNamespaceError(e, 0L));
        }
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, SingleResultCallback<Long> callback) {
        AsyncOperationHelper.executeRetryableReadAsync(binding, this.namespace.getDatabaseName(), this.getCommandCreator(binding.getSessionContext()), CommandResultDocumentCodec.create(DECODER, Collections.singletonList("firstBatch")), this.asyncTransformer(), this.retryReads, (result, t) -> {
            if (CommandOperationHelper.isNamespaceError(t)) {
                callback.onResult(0L, null);
            } else {
                callback.onResult((Long)result, t);
            }
        });
    }

    private SyncOperationHelper.CommandReadTransformer<BsonDocument, Long> transformer() {
        return (result, source, connection) -> this.transformResult((BsonDocument)result, connection.getDescription());
    }

    private AsyncOperationHelper.CommandReadTransformerAsync<BsonDocument, Long> asyncTransformer() {
        return (result, source, connection) -> this.transformResult((BsonDocument)result, connection.getDescription());
    }

    private long transformResult(BsonDocument result, ConnectionDescription connectionDescription) {
        return result.getNumber("n").longValue();
    }

    private CommandOperationHelper.CommandCreator getCommandCreator(SessionContext sessionContext) {
        return (serverDescription, connectionDescription) -> {
            BsonDocument document = new BsonDocument("count", new BsonString(this.namespace.getCollectionName()));
            OperationReadConcernHelper.appendReadConcernToCommand(sessionContext, connectionDescription.getMaxWireVersion(), document);
            DocumentHelper.putIfNotZero(document, "maxTimeMS", this.maxTimeMS);
            if (this.comment != null) {
                document.put("comment", this.comment);
            }
            return document;
        };
    }
}

