/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.internal.operation;

import com.dimensionrogue.libs.bson.BsonDocument;
import com.dimensionrogue.libs.bson.BsonString;
import com.dimensionrogue.libs.mongodb.MongoCommandException;
import com.dimensionrogue.libs.mongodb.MongoNamespace;
import com.dimensionrogue.libs.mongodb.WriteConcern;
import com.dimensionrogue.libs.mongodb.assertions.Assertions;
import com.dimensionrogue.libs.mongodb.internal.async.ErrorHandlingResultCallback;
import com.dimensionrogue.libs.mongodb.internal.async.SingleResultCallback;
import com.dimensionrogue.libs.mongodb.internal.binding.AsyncWriteBinding;
import com.dimensionrogue.libs.mongodb.internal.binding.WriteBinding;
import com.dimensionrogue.libs.mongodb.internal.operation.AsyncOperationHelper;
import com.dimensionrogue.libs.mongodb.internal.operation.AsyncWriteOperation;
import com.dimensionrogue.libs.mongodb.internal.operation.CommandOperationHelper;
import com.dimensionrogue.libs.mongodb.internal.operation.DocumentHelper;
import com.dimensionrogue.libs.mongodb.internal.operation.OperationHelper;
import com.dimensionrogue.libs.mongodb.internal.operation.SyncOperationHelper;
import com.dimensionrogue.libs.mongodb.internal.operation.WriteConcernHelper;
import com.dimensionrogue.libs.mongodb.internal.operation.WriteOperation;
import com.dimensionrogue.libs.mongodb.lang.Nullable;
import java.util.concurrent.TimeUnit;

public class DropIndexOperation
implements AsyncWriteOperation<Void>,
WriteOperation<Void> {
    private final MongoNamespace namespace;
    private final String indexName;
    private final BsonDocument indexKeys;
    private final WriteConcern writeConcern;
    private long maxTimeMS;

    public DropIndexOperation(MongoNamespace namespace, String indexName) {
        this(namespace, indexName, null);
    }

    public DropIndexOperation(MongoNamespace namespace, BsonDocument keys) {
        this(namespace, keys, null);
    }

    public DropIndexOperation(MongoNamespace namespace, String indexName, @Nullable WriteConcern writeConcern) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.indexName = Assertions.notNull("indexName", indexName);
        this.indexKeys = null;
        this.writeConcern = writeConcern;
    }

    public DropIndexOperation(MongoNamespace namespace, BsonDocument indexKeys, @Nullable WriteConcern writeConcern) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.indexKeys = Assertions.notNull("indexKeys", indexKeys);
        this.indexName = null;
        this.writeConcern = writeConcern;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public DropIndexOperation maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        Assertions.isTrueArgument("maxTime >= 0", maxTime >= 0L);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public Void execute(WriteBinding binding) {
        return SyncOperationHelper.withConnection(binding, connection -> {
            try {
                SyncOperationHelper.executeCommand(binding, this.namespace.getDatabaseName(), this.getCommand(), connection, SyncOperationHelper.writeConcernErrorTransformer());
            }
            catch (MongoCommandException e) {
                CommandOperationHelper.rethrowIfNotNamespaceError(e);
            }
            return null;
        });
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, SingleResultCallback<Void> callback) {
        AsyncOperationHelper.withAsyncConnection(binding, (connection, t) -> {
            SingleResultCallback<Object> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER);
            if (t != null) {
                errHandlingCallback.onResult(null, t);
            } else {
                SingleResultCallback releasingCallback = AsyncOperationHelper.releasingCallback(errHandlingCallback, connection);
                AsyncOperationHelper.executeCommandAsync(binding, this.namespace.getDatabaseName(), this.getCommand(), connection, AsyncOperationHelper.writeConcernErrorTransformerAsync(), (result, t1) -> {
                    if (t1 != null && !CommandOperationHelper.isNamespaceError(t1)) {
                        releasingCallback.onResult(null, t1);
                    } else {
                        releasingCallback.onResult(result, null);
                    }
                });
            }
        });
    }

    private BsonDocument getCommand() {
        BsonDocument command = new BsonDocument("dropIndexes", new BsonString(this.namespace.getCollectionName()));
        if (this.indexName != null) {
            command.put("index", new BsonString(this.indexName));
        } else {
            command.put("index", this.indexKeys);
        }
        DocumentHelper.putIfNotZero(command, "maxTimeMS", this.maxTimeMS);
        WriteConcernHelper.appendWriteConcernToCommand(this.writeConcern, command);
        return command;
    }
}

