/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.internal.operation;

import com.dimensionrogue.libs.bson.BsonDocument;
import com.dimensionrogue.libs.bson.BsonInt32;
import com.dimensionrogue.libs.mongodb.WriteConcern;
import com.dimensionrogue.libs.mongodb.assertions.Assertions;
import com.dimensionrogue.libs.mongodb.internal.async.ErrorHandlingResultCallback;
import com.dimensionrogue.libs.mongodb.internal.async.SingleResultCallback;
import com.dimensionrogue.libs.mongodb.internal.binding.AsyncWriteBinding;
import com.dimensionrogue.libs.mongodb.internal.binding.WriteBinding;
import com.dimensionrogue.libs.mongodb.internal.operation.AsyncOperationHelper;
import com.dimensionrogue.libs.mongodb.internal.operation.AsyncWriteOperation;
import com.dimensionrogue.libs.mongodb.internal.operation.OperationHelper;
import com.dimensionrogue.libs.mongodb.internal.operation.SyncOperationHelper;
import com.dimensionrogue.libs.mongodb.internal.operation.WriteConcernHelper;
import com.dimensionrogue.libs.mongodb.internal.operation.WriteOperation;
import com.dimensionrogue.libs.mongodb.lang.Nullable;

public class DropDatabaseOperation
implements AsyncWriteOperation<Void>,
WriteOperation<Void> {
    private final String databaseName;
    private final WriteConcern writeConcern;

    public DropDatabaseOperation(String databaseName) {
        this(databaseName, null);
    }

    public DropDatabaseOperation(String databaseName, @Nullable WriteConcern writeConcern) {
        this.databaseName = Assertions.notNull("databaseName", databaseName);
        this.writeConcern = writeConcern;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    @Override
    public Void execute(WriteBinding binding) {
        return SyncOperationHelper.withConnection(binding, connection -> {
            SyncOperationHelper.executeCommand(binding, this.databaseName, this.getCommand(), connection, SyncOperationHelper.writeConcernErrorTransformer());
            return null;
        });
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, SingleResultCallback<Void> callback) {
        AsyncOperationHelper.withAsyncConnection(binding, (connection, t) -> {
            SingleResultCallback<Object> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER);
            if (t != null) {
                errHandlingCallback.onResult(null, t);
            } else {
                AsyncOperationHelper.executeCommandAsync(binding, this.databaseName, this.getCommand(), connection, AsyncOperationHelper.writeConcernErrorTransformerAsync(), AsyncOperationHelper.releasingCallback(errHandlingCallback, connection));
            }
        });
    }

    private BsonDocument getCommand() {
        BsonDocument commandDocument = new BsonDocument("dropDatabase", new BsonInt32(1));
        WriteConcernHelper.appendWriteConcernToCommand(this.writeConcern, commandDocument);
        return commandDocument;
    }
}

