/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.internal.operation;

import com.dimensionrogue.libs.bson.BsonBoolean;
import com.dimensionrogue.libs.bson.BsonDocument;
import com.dimensionrogue.libs.bson.BsonInt32;
import com.dimensionrogue.libs.bson.BsonInt64;
import com.dimensionrogue.libs.bson.BsonString;
import com.dimensionrogue.libs.bson.BsonValue;
import com.dimensionrogue.libs.mongodb.lang.Nullable;

final class DocumentHelper {
    private DocumentHelper() {
    }

    static void putIfTrue(BsonDocument command, String key, boolean condition) {
        if (condition) {
            command.put(key, BsonBoolean.TRUE);
        }
    }

    static void putIfFalse(BsonDocument command, String key, boolean condition) {
        if (!condition) {
            command.put(key, BsonBoolean.FALSE);
        }
    }

    static void putIfNotNullOrEmpty(BsonDocument command, String key, @Nullable BsonDocument documentValue) {
        if (documentValue != null && !documentValue.isEmpty()) {
            command.put(key, documentValue);
        }
    }

    static void putIfNotNull(BsonDocument command, String key, @Nullable BsonValue value) {
        if (value != null) {
            command.put(key, value);
        }
    }

    static void putIfNotNull(BsonDocument command, String key, @Nullable String value) {
        if (value != null) {
            command.put(key, new BsonString(value));
        }
    }

    static void putIfNotZero(BsonDocument command, String key, int value) {
        if (value != 0) {
            command.put(key, new BsonInt32(value));
        }
    }

    static void putIfNotZero(BsonDocument command, String key, long value) {
        if (value != 0L) {
            command.put(key, new BsonInt64(value));
        }
    }
}

