/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.internal.operation;

import com.dimensionrogue.libs.bson.BsonArray;
import com.dimensionrogue.libs.bson.BsonDocument;
import com.dimensionrogue.libs.bson.BsonString;
import com.dimensionrogue.libs.bson.codecs.BsonDocumentCodec;
import com.dimensionrogue.libs.mongodb.WriteConcern;
import com.dimensionrogue.libs.mongodb.assertions.Assertions;
import com.dimensionrogue.libs.mongodb.client.model.Collation;
import com.dimensionrogue.libs.mongodb.internal.async.ErrorHandlingResultCallback;
import com.dimensionrogue.libs.mongodb.internal.async.SingleResultCallback;
import com.dimensionrogue.libs.mongodb.internal.binding.AsyncWriteBinding;
import com.dimensionrogue.libs.mongodb.internal.binding.WriteBinding;
import com.dimensionrogue.libs.mongodb.internal.operation.AsyncOperationHelper;
import com.dimensionrogue.libs.mongodb.internal.operation.AsyncWriteOperation;
import com.dimensionrogue.libs.mongodb.internal.operation.OperationHelper;
import com.dimensionrogue.libs.mongodb.internal.operation.SyncOperationHelper;
import com.dimensionrogue.libs.mongodb.internal.operation.WriteConcernHelper;
import com.dimensionrogue.libs.mongodb.internal.operation.WriteOperation;
import com.dimensionrogue.libs.mongodb.lang.Nullable;
import java.util.List;

public class CreateViewOperation
implements AsyncWriteOperation<Void>,
WriteOperation<Void> {
    private final String databaseName;
    private final String viewName;
    private final String viewOn;
    private final List<BsonDocument> pipeline;
    private final WriteConcern writeConcern;
    private Collation collation;

    public CreateViewOperation(String databaseName, String viewName, String viewOn, List<BsonDocument> pipeline, WriteConcern writeConcern) {
        this.databaseName = Assertions.notNull("databaseName", databaseName);
        this.viewName = Assertions.notNull("viewName", viewName);
        this.viewOn = Assertions.notNull("viewOn", viewOn);
        this.pipeline = Assertions.notNull("pipeline", pipeline);
        this.writeConcern = Assertions.notNull("writeConcern", writeConcern);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getViewName() {
        return this.viewName;
    }

    public String getViewOn() {
        return this.viewOn;
    }

    public List<BsonDocument> getPipeline() {
        return this.pipeline;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public CreateViewOperation collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public Void execute(WriteBinding binding) {
        return SyncOperationHelper.withConnection(binding, connection -> {
            SyncOperationHelper.executeCommand(binding, this.databaseName, this.getCommand(), new BsonDocumentCodec(), SyncOperationHelper.writeConcernErrorTransformer());
            return null;
        });
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, SingleResultCallback<Void> callback) {
        AsyncOperationHelper.withAsyncConnection(binding, (connection, t) -> {
            SingleResultCallback<Object> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER);
            if (t != null) {
                errHandlingCallback.onResult(null, t);
            } else {
                SingleResultCallback wrappedCallback = AsyncOperationHelper.releasingCallback(errHandlingCallback, connection);
                AsyncOperationHelper.executeCommandAsync(binding, this.databaseName, this.getCommand(), connection, AsyncOperationHelper.writeConcernErrorTransformerAsync(), wrappedCallback);
            }
        });
    }

    private BsonDocument getCommand() {
        BsonDocument commandDocument = new BsonDocument("create", new BsonString(this.viewName)).append("viewOn", new BsonString(this.viewOn)).append("pipeline", new BsonArray(this.pipeline));
        if (this.collation != null) {
            commandDocument.put("collation", this.collation.asDocument());
        }
        WriteConcernHelper.appendWriteConcernToCommand(this.writeConcern, commandDocument);
        return commandDocument;
    }
}

