/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.internal.operation;

import com.dimensionrogue.libs.bson.BsonArray;
import com.dimensionrogue.libs.bson.BsonDocument;
import com.dimensionrogue.libs.bson.BsonString;
import com.dimensionrogue.libs.mongodb.MongoNamespace;
import com.dimensionrogue.libs.mongodb.assertions.Assertions;
import com.dimensionrogue.libs.mongodb.internal.operation.AbstractWriteSearchIndexOperation;
import com.dimensionrogue.libs.mongodb.internal.operation.SearchIndexRequest;
import java.util.List;
import java.util.stream.Collectors;

final class CreateSearchIndexesOperation
extends AbstractWriteSearchIndexOperation {
    private static final String COMMAND_NAME = "createSearchIndexes";
    private final List<SearchIndexRequest> indexRequests;

    CreateSearchIndexesOperation(MongoNamespace namespace, List<SearchIndexRequest> indexRequests) {
        super(namespace);
        this.indexRequests = Assertions.assertNotNull(indexRequests);
    }

    private static BsonArray convert(List<SearchIndexRequest> requests) {
        return requests.stream().map(CreateSearchIndexesOperation::convert).collect(Collectors.toCollection(BsonArray::new));
    }

    private static BsonDocument convert(SearchIndexRequest request) {
        BsonDocument bsonIndexRequest = new BsonDocument();
        String searchIndexName = request.getIndexName();
        if (searchIndexName != null) {
            bsonIndexRequest.append("name", new BsonString(searchIndexName));
        }
        bsonIndexRequest.append("definition", request.getDefinition());
        return bsonIndexRequest;
    }

    @Override
    BsonDocument buildCommand() {
        return new BsonDocument(COMMAND_NAME, new BsonString(this.getNamespace().getCollectionName())).append("indexes", CreateSearchIndexesOperation.convert(this.indexRequests));
    }
}

