/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.internal.operation;

import com.dimensionrogue.libs.bson.BsonArray;
import com.dimensionrogue.libs.bson.BsonDocumentWrapper;
import com.dimensionrogue.libs.bson.BsonReader;
import com.dimensionrogue.libs.bson.BsonType;
import com.dimensionrogue.libs.bson.BsonValue;
import com.dimensionrogue.libs.bson.codecs.BsonArrayCodec;
import com.dimensionrogue.libs.bson.codecs.Decoder;
import com.dimensionrogue.libs.bson.codecs.DecoderContext;
import com.dimensionrogue.libs.bson.codecs.configuration.CodecRegistry;
import com.dimensionrogue.libs.mongodb.internal.operation.BsonArrayWrapper;
import java.util.ArrayList;

class CommandResultArrayCodec<T>
extends BsonArrayCodec {
    private final Decoder<T> decoder;

    CommandResultArrayCodec(CodecRegistry registry, Decoder<T> decoder) {
        super(registry);
        this.decoder = decoder;
    }

    @Override
    public BsonArray decode(BsonReader reader, DecoderContext decoderContext) {
        reader.readStartArray();
        ArrayList<T> list = new ArrayList<T>();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            if (reader.getCurrentBsonType() == BsonType.NULL) {
                reader.readNull();
                list.add(null);
                continue;
            }
            list.add(this.decoder.decode(reader, decoderContext));
        }
        reader.readEndArray();
        return new BsonArrayWrapper(list);
    }

    @Override
    protected BsonValue readValue(BsonReader reader, DecoderContext decoderContext) {
        if (reader.getCurrentBsonType() == BsonType.DOCUMENT) {
            return new BsonDocumentWrapper<T>(this.decoder.decode(reader, decoderContext), null);
        }
        return super.readValue(reader, decoderContext);
    }
}

