/*
 * Decompiled with CFR 0.152.
 */
package com.dimensionrogue.libs.mongodb.internal.operation;

import com.dimensionrogue.libs.bson.BsonArray;
import com.dimensionrogue.libs.bson.BsonBoolean;
import com.dimensionrogue.libs.bson.BsonDocument;
import com.dimensionrogue.libs.bson.BsonInt32;
import com.dimensionrogue.libs.bson.BsonString;
import com.dimensionrogue.libs.bson.BsonTimestamp;
import com.dimensionrogue.libs.bson.BsonValue;
import com.dimensionrogue.libs.bson.RawBsonDocument;
import com.dimensionrogue.libs.bson.codecs.Decoder;
import com.dimensionrogue.libs.bson.codecs.RawBsonDocumentCodec;
import com.dimensionrogue.libs.mongodb.MongoNamespace;
import com.dimensionrogue.libs.mongodb.assertions.Assertions;
import com.dimensionrogue.libs.mongodb.client.model.Collation;
import com.dimensionrogue.libs.mongodb.client.model.changestream.FullDocument;
import com.dimensionrogue.libs.mongodb.client.model.changestream.FullDocumentBeforeChange;
import com.dimensionrogue.libs.mongodb.internal.async.AsyncAggregateResponseBatchCursor;
import com.dimensionrogue.libs.mongodb.internal.async.AsyncBatchCursor;
import com.dimensionrogue.libs.mongodb.internal.async.SingleResultCallback;
import com.dimensionrogue.libs.mongodb.internal.binding.AsyncReadBinding;
import com.dimensionrogue.libs.mongodb.internal.binding.ReadBinding;
import com.dimensionrogue.libs.mongodb.internal.client.model.changestream.ChangeStreamLevel;
import com.dimensionrogue.libs.mongodb.internal.operation.AggregateOperationImpl;
import com.dimensionrogue.libs.mongodb.internal.operation.AggregateResponseBatchCursor;
import com.dimensionrogue.libs.mongodb.internal.operation.AsyncChangeStreamBatchCursor;
import com.dimensionrogue.libs.mongodb.internal.operation.AsyncOperationHelper;
import com.dimensionrogue.libs.mongodb.internal.operation.AsyncReadOperation;
import com.dimensionrogue.libs.mongodb.internal.operation.BatchCursor;
import com.dimensionrogue.libs.mongodb.internal.operation.ChangeStreamBatchCursor;
import com.dimensionrogue.libs.mongodb.internal.operation.ReadOperation;
import com.dimensionrogue.libs.mongodb.internal.operation.SyncOperationHelper;
import com.dimensionrogue.libs.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ChangeStreamOperation<T>
implements AsyncReadOperation<AsyncBatchCursor<T>>,
ReadOperation<BatchCursor<T>> {
    private static final RawBsonDocumentCodec RAW_BSON_DOCUMENT_CODEC = new RawBsonDocumentCodec();
    private final AggregateOperationImpl<RawBsonDocument> wrapped;
    private final FullDocument fullDocument;
    private final FullDocumentBeforeChange fullDocumentBeforeChange;
    private final Decoder<T> decoder;
    private final ChangeStreamLevel changeStreamLevel;
    private BsonDocument resumeAfter;
    private BsonDocument startAfter;
    private BsonTimestamp startAtOperationTime;
    private boolean showExpandedEvents;

    public ChangeStreamOperation(MongoNamespace namespace, FullDocument fullDocument, FullDocumentBeforeChange fullDocumentBeforeChange, List<BsonDocument> pipeline, Decoder<T> decoder) {
        this(namespace, fullDocument, fullDocumentBeforeChange, pipeline, decoder, ChangeStreamLevel.COLLECTION);
    }

    public ChangeStreamOperation(MongoNamespace namespace, FullDocument fullDocument, FullDocumentBeforeChange fullDocumentBeforeChange, List<BsonDocument> pipeline, Decoder<T> decoder, ChangeStreamLevel changeStreamLevel) {
        this.wrapped = new AggregateOperationImpl<RawBsonDocument>(namespace, pipeline, RAW_BSON_DOCUMENT_CODEC, this.getAggregateTarget(), this.getPipelineCreator());
        this.fullDocument = Assertions.notNull("fullDocument", fullDocument);
        this.fullDocumentBeforeChange = Assertions.notNull("fullDocumentBeforeChange", fullDocumentBeforeChange);
        this.decoder = Assertions.notNull("decoder", decoder);
        this.changeStreamLevel = Assertions.notNull("changeStreamLevel", changeStreamLevel);
    }

    public MongoNamespace getNamespace() {
        return this.wrapped.getNamespace();
    }

    public Decoder<T> getDecoder() {
        return this.decoder;
    }

    public FullDocument getFullDocument() {
        return this.fullDocument;
    }

    public BsonDocument getResumeAfter() {
        return this.resumeAfter;
    }

    public ChangeStreamOperation<T> resumeAfter(BsonDocument resumeAfter) {
        this.resumeAfter = resumeAfter;
        return this;
    }

    public BsonDocument getStartAfter() {
        return this.startAfter;
    }

    public ChangeStreamOperation<T> startAfter(BsonDocument startAfter) {
        this.startAfter = startAfter;
        return this;
    }

    public List<BsonDocument> getPipeline() {
        return this.wrapped.getPipeline();
    }

    public Integer getBatchSize() {
        return this.wrapped.getBatchSize();
    }

    public ChangeStreamOperation<T> batchSize(@Nullable Integer batchSize) {
        this.wrapped.batchSize(batchSize);
        return this;
    }

    public long getMaxAwaitTime(TimeUnit timeUnit) {
        return this.wrapped.getMaxAwaitTime(timeUnit);
    }

    public ChangeStreamOperation<T> maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        this.wrapped.maxAwaitTime(maxAwaitTime, timeUnit);
        return this;
    }

    public Collation getCollation() {
        return this.wrapped.getCollation();
    }

    public ChangeStreamOperation<T> collation(Collation collation) {
        this.wrapped.collation(collation);
        return this;
    }

    public ChangeStreamOperation<T> startAtOperationTime(BsonTimestamp startAtOperationTime) {
        this.startAtOperationTime = startAtOperationTime;
        return this;
    }

    public BsonTimestamp getStartAtOperationTime() {
        return this.startAtOperationTime;
    }

    public ChangeStreamOperation<T> retryReads(boolean retryReads) {
        this.wrapped.retryReads(retryReads);
        return this;
    }

    public boolean getRetryReads() {
        return this.wrapped.getRetryReads();
    }

    @Nullable
    public BsonValue getComment() {
        return this.wrapped.getComment();
    }

    public ChangeStreamOperation<T> comment(BsonValue comment) {
        this.wrapped.comment(comment);
        return this;
    }

    public boolean getShowExpandedEvents() {
        return this.showExpandedEvents;
    }

    public ChangeStreamOperation<T> showExpandedEvents(boolean showExpandedEvents) {
        this.showExpandedEvents = showExpandedEvents;
        return this;
    }

    @Override
    public BatchCursor<T> execute(ReadBinding binding) {
        return SyncOperationHelper.withReadConnectionSource(binding, source -> {
            AggregateResponseBatchCursor cursor = (AggregateResponseBatchCursor)this.wrapped.execute(binding);
            return new ChangeStreamBatchCursor(this, cursor, binding, this.setChangeStreamOptions(cursor.getPostBatchResumeToken(), cursor.getOperationTime(), cursor.getMaxWireVersion(), cursor.isFirstBatchEmpty()), cursor.getMaxWireVersion());
        });
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, SingleResultCallback<AsyncBatchCursor<T>> callback) {
        this.wrapped.executeAsync(binding, (result, t) -> {
            if (t != null) {
                callback.onResult(null, t);
            } else {
                AsyncAggregateResponseBatchCursor cursor = (AsyncAggregateResponseBatchCursor)result;
                AsyncOperationHelper.withAsyncReadConnectionSource(binding, (source, t1) -> {
                    if (t1 != null) {
                        callback.onResult(null, t1);
                    } else {
                        callback.onResult(new AsyncChangeStreamBatchCursor(this, cursor, binding, this.setChangeStreamOptions(cursor.getPostBatchResumeToken(), cursor.getOperationTime(), cursor.getMaxWireVersion(), cursor.isFirstBatchEmpty()), cursor.getMaxWireVersion()), null);
                    }
                    source.release();
                });
            }
        });
    }

    @Nullable
    private BsonDocument setChangeStreamOptions(@Nullable BsonDocument postBatchResumeToken, BsonTimestamp operationTime, int maxWireVersion, boolean firstBatchEmpty) {
        BsonDocument resumeToken = null;
        if (this.startAfter != null) {
            resumeToken = this.startAfter;
        } else if (this.resumeAfter != null) {
            resumeToken = this.resumeAfter;
        } else if (this.startAtOperationTime == null && postBatchResumeToken == null && firstBatchEmpty && maxWireVersion >= 7) {
            this.startAtOperationTime = operationTime;
        }
        return resumeToken;
    }

    public void setChangeStreamOptionsForResume(@Nullable BsonDocument resumeToken, int maxWireVersion) {
        this.startAfter = null;
        if (resumeToken != null) {
            this.startAtOperationTime = null;
            this.resumeAfter = resumeToken;
        } else if (this.startAtOperationTime != null && maxWireVersion >= 7) {
            this.resumeAfter = null;
        } else {
            this.resumeAfter = null;
            this.startAtOperationTime = null;
        }
    }

    private AggregateOperationImpl.AggregateTarget getAggregateTarget() {
        return () -> this.changeStreamLevel == ChangeStreamLevel.COLLECTION ? new BsonString(this.getNamespace().getCollectionName()) : new BsonInt32(1);
    }

    private AggregateOperationImpl.PipelineCreator getPipelineCreator() {
        return () -> {
            ArrayList<BsonDocument> changeStreamPipeline = new ArrayList<BsonDocument>();
            BsonDocument changeStream = new BsonDocument();
            if (this.fullDocument != FullDocument.DEFAULT) {
                changeStream.append("fullDocument", new BsonString(this.fullDocument.getValue()));
            }
            if (this.fullDocumentBeforeChange != FullDocumentBeforeChange.DEFAULT) {
                changeStream.append("fullDocumentBeforeChange", new BsonString(this.fullDocumentBeforeChange.getValue()));
            }
            if (this.changeStreamLevel == ChangeStreamLevel.CLIENT) {
                changeStream.append("allChangesForCluster", BsonBoolean.TRUE);
            }
            if (this.showExpandedEvents) {
                changeStream.append("showExpandedEvents", BsonBoolean.TRUE);
            }
            if (this.resumeAfter != null) {
                changeStream.append("resumeAfter", this.resumeAfter);
            }
            if (this.startAfter != null) {
                changeStream.append("startAfter", this.startAfter);
            }
            if (this.startAtOperationTime != null) {
                changeStream.append("startAtOperationTime", this.startAtOperationTime);
            }
            changeStreamPipeline.add(new BsonDocument("$changeStream", changeStream));
            changeStreamPipeline.addAll(this.getPipeline());
            return new BsonArray(changeStreamPipeline);
        };
    }
}

